<?php

namespace App\Http\Resources\Report;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportTrainingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "TR_ID"      => $this->ID,
            "TR_REFERENCE_NO" => $this->TR_REFERENCE_NO,
            "TYPE"       => $this->type->TR_TYPE_NAME,
            "TOPIC_NAME" => $this->topic->TR_TOPIC_NAME,
            "LOCATION_NAME" => (isset($this->location)?$this->location->LOCATION_NAME:""),
            "TR_SCHEDULED_START_DATE" => (isset($this->TR_SCHEDULED_START_DATE)?showDate($this->TR_SCHEDULED_START_DATE, config("constants.EXCEL_DATE_FORMAT")):""),
            "TR_SCHEDULED_END_DATE"   => (isset($this->TR_SCHEDULED_END_DATE)?showDate($this->TR_SCHEDULED_END_DATE, config("constants.EXCEL_DATE_FORMAT")):""),     
            "TR_START_DATE" => (isset($this->TR_START_DATE)?showDate($this->TR_START_DATE, config("constants.EXCEL_DATE_FORMAT")):""),
            "TR_END_DATE"   => (isset($this->TR_END_DATE)?showDate($this->TR_END_DATE, config("constants.EXCEL_DATE_FORMAT")):""),     
            // "MONTH"      => showDate($this->TR_START_DATE, "M"),
            // "MONTH_FULL" => showDate($this->TR_START_DATE, "F"),
            "IS_PLANNED" => $this->IS_PLANNED == 1 ? "Planned" : "Unplanned",
            "TRAINERS"   => $this->TRAINERS,
            "REMARKS"    => $this->REMARKS,
            // "IS_EDIT_BTN"   => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0),
            // "IS_DELETE_BTN" => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)
        ];
    }

    public static function transformTraining($trdetails, $action = null)
    {
        
         if (!isset($action)) {
            $action = "";
        }        
        $editable = $trdetails->STAGE_ID == 1 && $action !== 'view';
        $unplannedEditable = $trdetails->STAGE_ID == 1 && $trdetails->IS_PLANNED == 0 && $action !== 'view';
        
        return [
            'ID' => ["EDITABLE" => false, "VALUE" => $trdetails->ID],
            'TR_ID' => ["EDITABLE" => false, "VALUE" => $trdetails->ID],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $trdetails->SITE_ID],
            'TR_REFERENCE_NO' => ["EDITABLE" => false, "VALUE" => $trdetails->TR_REFERENCE_NO],
            'LOCATION_ID' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->LOCATION_ID],
            'TYPE_ID' => ["EDITABLE" => false, "VALUE" => $trdetails->TYPE_ID],
            'TOPIC_ID' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->TOPIC_ID],
            'TOPIC_NAME' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->topic->TR_TOPIC_NAME],
            'TR_SCHEDULED_START_DATE' => ["EDITABLE" => false, "VALUE" => ((isset($trdetails->TR_SCHEDULED_START_DATE))?showDate($trdetails->TR_SCHEDULED_START_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TR_SCHEDULED_END_DATE' => ["EDITABLE" => false, "VALUE" => ((isset($trdetails->TR_SCHEDULED_END_DATE))?showDate($trdetails->TR_SCHEDULED_END_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TR_START_DATE' => ["EDITABLE" => $editable, "VALUE" => ((isset($trdetails->TR_START_DATE))?showDate($trdetails->TR_START_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TR_END_DATE' => ["EDITABLE" => $editable, "VALUE" => ((isset($trdetails->TR_END_DATE))?showDate($trdetails->TR_END_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TRAINERS' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->TRAINERS],
            'REMARKS' => ["EDITABLE" => $editable, "VALUE" => $trdetails->REMARKS],
            'STATUS' => ["EDITABLE" => false, "VALUE" => $trdetails->stage->STAGE_NAME],
            'IS_PLANNED' => ["EDITABLE" => false, "VALUE" => $trdetails->IS_PLANNED],
            'TR_MIN_START_DATE' => ["EDITABLE" => false, "VALUE" => ((isset($trdetails->TR_SCHEDULED_START_DATE))?showDate($trdetails->TR_SCHEDULED_START_DATE, config("constants.DATE_TIME_FORMAT")):"")],
        ];
    }

    
}