<?php

namespace App\Http\Resources\Report;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportPtwResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "PTW_ID"            => $this->ID,
            "AUTO_GEN_REF_NO"   => $this->AUTO_GEN_REF_NO,
            "TYPE_NAME"         => $this->type->TYPE_NAME,
            "CURR_STATE"        => ($this->RENEWAL_COUNT == 0) ? (($this->STAGE_ID == 13) ? "Renewed" : "Initial") 
                                    : ordinalConversion($this->RENEWAL_COUNT)." Renewal",
            "PERMIT_START_TIME" => showDate($this->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")),
            "PERMIT_END_TIME"   => showDate($this->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")),
            "LOCATION_NAME"     => $this->location->LOCATION_NAME,
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"       => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "PTW_TYPE_ID"       => $this->TYPE_ID
        ];
    }
}