<?php

namespace App\Http\Resources\Report;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use DateTime;

class ReportObservationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "OBS_ID"           => $this->ID,
            "TYPE_NAME"       => $this->obstype->OBS_TYPE_NAME,
            "OBSERVATION_REFERENCE_NO" => $this->OBSERVATION_REFERENCE_NO,
            "DESCRIPTION"       => $this->DESCRIPTION,           
            "OBS_START_DATE"    => showDate($this->OBS_START_DATE, config("constants.DATE_FORMAT")),
            "OBS_END_DATE"      => showDate($this->OBS_END_DATE, config("constants.DATE_FORMAT")),            
            "LOCATION_NAME"     => (isset($this->location)?$this->location->LOCATION_NAME:""),
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"        => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "SEVERITY_ID"       => $this->SEVERITY_ID,
            "SEVERITY_NAME"     => (isset($this->severity)?$this->severity->SEVERITY_NAME:""),
            "LIKELIHOOD_ID"     => $this->LIKELIHOOD_ID,
            "LIKELIHOOD_NAME"   => (isset($this->likelihood)?$this->likelihood->LIKELIHOOD_NAME:""),
            "RISK_FACTOR"       => ((isset($this->severity) && isset($this->likelihood))?($this->severity->SEVERITY_NAME.$this->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_COLOUR"=> ((isset($this->severity) && isset($this->likelihood))?getSeverityLikehoodColor($this->severity->SEVERITY_NAME,$this->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_STAGE" => ((isset($this->severity) && isset($this->likelihood))?getSeverityLikehoodStage($this->severity->SEVERITY_NAME,$this->likelihood->LIKELIHOOD_NAME):""),
            "IS_DELETE_BTN"     => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)
        ];
    }
}