<?php

namespace App\Http\Resources\Report;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportInspectionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "INSP_ID"           => $this->ID,
            "TYPE_NAME"       => $this->type->INSP_TYPE_NAME,
            "INSPECTION_REFERENCE_NO" => $this->INSPECTION_REFERENCE_NO,
            "DESCRIPTION"       => $this->DESCRIPTION,
            "INSP_DATE"         => showDate($this->INSP_DATE, config("constants.DATE_FORMAT")),
            "LOCATION_NAME"     => (isset($this->location)?$this->location->LOCATION_NAME:""),
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"        => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "IS_DELETE_BTN"     => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)
        ];
    }
}