<?php

namespace App\Http\Resources\Report;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportHiraResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "HIRA_ID"           => $this->ID,
            "HIRA_REFERENCE_NO" => $this->HIRA_REFERENCE_NO,
            "TITLE"             => $this->TITLE,
            "CURR_STATE"        => ($this->RENEWAL_COUNT == 0) ? (($this->STAGE_ID == 7) ? "Revised" :(($this->STAGE_ID == 9) ? "Renewed" : "Initial"))
                                    : ordinalConversion($this->RENEWAL_COUNT).(($this->parent->STAGE_ID == 9)? " Renewal" : " Approval"),
            "HIRA_START_DATE"   => showDate($this->HIRA_START_DATE, config("constants.DATE_FORMAT")),
            "HIRA_END_DATE"     => showDate($this->HIRA_END_DATE, config("constants.DATE_FORMAT")),
            "LOCATION_NAME"     => $this->location->LOCATION_NAME,
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"        => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "IS_DELETE_BTN"     => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)
        ];
    }
}