<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class PtwResource extends JsonResource
{
    use EncDecService;
    
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "PTW_ID"            => $this->ID,
            "AUTO_GEN_REF_NO"   => $this->AUTO_GEN_REF_NO,
            "TYPE_NAME"         => $this->type->TYPE_NAME,
            "CURR_STATE"        => ($this->RENEWAL_COUNT == 0) ? (($this->STAGE_ID == 13) ? "Renewed" : "Initial") 
                                    : ordinalConversion($this->RENEWAL_COUNT)." Renewal",
            "PERMIT_START_TIME" => showDate($this->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")),
            "PERMIT_END_TIME"   => showDate($this->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")),
            "LOCATION_NAME"     => $this->location->LOCATION_NAME,
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"       => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "PTW_TYPE_ID"       => $this->TYPE_ID
        ];
    }

    public static function transformPtw($ptwdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }        
        $editable = $ptwdetails->STAGE_ID == 1 && $action !== 'view';
        $editableType2 = $ptwdetails->STAGE_ID == 1 &&  $ptwdetails->TYPE_ID == 2 && $action !== 'view'; 
        
        $max_permit_date = $ptwdetails->PERMIT_END_TIME;
        if($ptwdetails->PARENT_PTW_ID > 0){
           
            $parentPtwDate = $ptwdetails->parent->PERMIT_END_TIME ?? "";
            if($parentPtwDate){

                $max_permit_date = date("Y-m-d H:i:s", strtotime('+6 days', strtotime($parentPtwDate)));
            }else{
                $max_permit_date = date("Y-m-d H:i:s", strtotime('+6 days', strtotime($ptwdetails->PERMIT_END_TIME)));
            }
        }
        if($ptwdetails->STAGE_ID == 5){            
            $max_permit_date = date("Y-m-d H:i:s", strtotime('+6 days', strtotime($ptwdetails->PERMIT_END_TIME)));
        }

        return [
            'ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->ID],
            'PTW_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->ID],
            'AUTO_GEN_REF_NO' => ["EDITABLE" => false, "VALUE" => $ptwdetails->AUTO_GEN_REF_NO],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->SITE_ID],
            'TYPE_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->TYPE_ID],
            'STATUS' => ["EDITABLE" => false, "VALUE" => $ptwdetails->stage->STAGE_NAME],
            'TOP_PARENT_PTW_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->TOP_PARENT_PTW_ID],
            'PARENT_PTW_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->PARENT_PTW_ID],
            'RENEWAL_COUNT' => ["EDITABLE" => false, "VALUE" => $ptwdetails->RENEWAL_COUNT],
            'LOCATION_ID' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->LOCATION_ID],
            'SOP_POLICY_ID' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->sopPolicy->pluck('SOP_ID')],
            'HIRA_REFERENCE_ID' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->hira->pluck('HIRA_ID')],
            'DECLARATIONS' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->declarations->pluck('DECLARATION_ID')],
            'DESCRIPTION' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->DESCRIPTION],
            'IS_CONTRACTOR_INFO_REQUIRED' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->IS_CONTRACTOR_INFO_REQUIRED],
            'CONTRACTOR_ID' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->CONTRACTOR_ID],
            'IS_ISOLATION_REQUIRED' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->IS_ISOLATION_REQUIRED],
            'REMARKS' => ["EDITABLE" => $editable, "VALUE" => $ptwdetails->REMARKS],
            'PERMIT_START_TIME' => ["EDITABLE" => $editable, "VALUE" => showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT"))],
            'PERMIT_END_TIME' => ["EDITABLE" => $editable, "VALUE" => showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT"))],
            'SPRINKLER_PROTECTION' => ["EDITABLE" => $editableType2, "VALUE" => $ptwdetails->SPRINKLER_PROTECTION],
            'SMOKE_DETECTION' => ["EDITABLE" => $editableType2, "VALUE" => $ptwdetails->SMOKE_DETECTION],
            'ON_A_ROOF' => ["EDITABLE" => $editableType2, "VALUE" => $ptwdetails->ON_A_ROOF],
            'MAX_PERMIT_DATE' => ["EDITABLE" => false, "VALUE" => showDate($max_permit_date, config("constants.DATE_TIME_FORMAT"))],
        ];
    }

    public static function transformPtwRenew($ptwdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }
                
        $editable = $ptwdetails->STAGE_ID == 5 && strtoupper($action) == 'RENEW';
        $editableType2 = $ptwdetails->STAGE_ID == 5 &&  $ptwdetails->TYPE_ID == 2 && strtoupper($action) == 'RENEW';

        $max_permit_date = date("Y-m-d H:i:s", strtotime('+6 days', strtotime($ptwdetails->PERMIT_END_TIME)));        

        return [
            'ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->ID],
            'PTW_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->ID],
            'AUTO_GEN_REF_NO' => ["EDITABLE" => false, "VALUE" => $ptwdetails->AUTO_GEN_REF_NO],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->SITE_ID],
            'TYPE_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->TYPE_ID],
            'STATUS' => ["EDITABLE" => false, "VALUE" => $ptwdetails->stage->STAGE_NAME],
            'TOP_PARENT_PTW_ID' => ["EDITABLE" => false, "VALUE" => ($ptwdetails->TOP_PARENT_PTW_ID != 0)? $ptwdetails->TOP_PARENT_PTW_ID : $ptwdetails->ID],
            'PARENT_PTW_ID' => ["EDITABLE" => false, "VALUE" => ($ptwdetails->PARENT_PTW_ID == 0 )?$ptwdetails->PARENT_PTW_ID : $ptwdetails->ID],
            'RENEWAL_COUNT' => ["EDITABLE" => false, "VALUE" => ($ptwdetails->RENEWAL_COUNT + 1)],
            'LOCATION_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->LOCATION_ID],
            'SOP_POLICY_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->sopPolicy->pluck('SOP_ID')],
            'HIRA_REFERENCE_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->hira->pluck('HIRA_ID')],
            'DECLARATIONS' => ["EDITABLE" => false, "VALUE" => $ptwdetails->declarations->pluck('DECLARATION_ID')],
            'DESCRIPTION' => ["EDITABLE" => false, "VALUE" => $ptwdetails->DESCRIPTION],
            'IS_CONTRACTOR_INFO_REQUIRED' => ["EDITABLE" => false, "VALUE" => $ptwdetails->IS_CONTRACTOR_INFO_REQUIRED],
            'CONTRACTOR_ID' => ["EDITABLE" => false, "VALUE" => $ptwdetails->CONTRACTOR_ID],
            'IS_ISOLATION_REQUIRED' => ["EDITABLE" => false, "VALUE" => $ptwdetails->IS_ISOLATION_REQUIRED],
            'REMARKS' => ["EDITABLE" => false, "VALUE" => $ptwdetails->REMARKS],
            'PERMIT_START_TIME' => ["EDITABLE" => $editable, "VALUE" => showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT"))],
            'PERMIT_END_TIME' => ["EDITABLE" => $editable, "VALUE" => showDate($max_permit_date, config("constants.DATE_TIME_FORMAT"))],
            'SPRINKLER_PROTECTION' => ["EDITABLE" => false, "VALUE" => $ptwdetails->SPRINKLER_PROTECTION],
            'SMOKE_DETECTION' => ["EDITABLE" => false, "VALUE" => $ptwdetails->SMOKE_DETECTION],
            'ON_A_ROOF' => ["EDITABLE" => false, "VALUE" => $ptwdetails->ON_A_ROOF],
            'MAX_PERMIT_DATE' => ["EDITABLE" => false, "VALUE" => showDate($max_permit_date, config("constants.DATE_TIME_FORMAT"))],
        ];
    }

    public function transformPtwReport($ptwdetails)
    {
             
        $approvedBy = "";
        $approvedDate = "";
        if(isset($ptwdetails->approvedby) && in_array($ptwdetails->STAGE_ID,[5,7,8,10,11,13])){
            $approvedData = $ptwdetails->approvedby->first();
            $actionTracker = $approvedData->actionTracker;
            if ($actionTracker) {
            // $approvedBy = $approvedData->actionTracker->FIRST_NAME.' '.$approvedData->actionTracker->LAST_NAME;
            $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
            $approvedDate = showDate($approvedData->CREATED_ON, config("constants.DATE_FORMAT"));
        }
        $reviewedBy = "";
        if(isset($ptwdetails->reviewedby) && in_array($ptwdetails->STAGE_ID,[3,5,7,8,10,11,13])){
            $reviewdData = $ptwdetails->reviewedby->first();
            $actionTracker = $reviewdData->actionTracker;
            if ($actionTracker) {
            // $reviewedBy = $reviewdData->actionTracker->FIRST_NAME.' '.$reviewdData->actionTracker->LAST_NAME;
            $reviewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        $closedReqBy = "";
        $closedBy = "";
        $suspendBy = "";
        $suspendReqBy = "";
        if(isset($ptwdetails->closedrequestby) && in_array($ptwdetails->STAGE_ID,[7,8])){
            $closedReqData = $ptwdetails->closedrequestby->first();
            $actionTracker = $closedReqData->actionTracker;
            if ($actionTracker) {
            // $closedReqBy = $closedReqData->actionTracker->FIRST_NAME.' '.$closedReqData->actionTracker->LAST_NAME;
            $closedReqBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        if(isset($ptwdetails->closedby) && in_array($ptwdetails->STAGE_ID,[8])){
            $closedData = $ptwdetails->closedby->first();
            $actionTracker = $closedData->actionTracker;
            if ($actionTracker) {
            // $closedBy = $closedData->actionTracker->FIRST_NAME.' '.$closedData->actionTracker->LAST_NAME;
            $closedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        if(isset($ptwdetails->suspendby) && in_array($ptwdetails->STAGE_ID,[10,11])){
            $suspendReqData = $ptwdetails->suspendrequestby->first();
            $actionTracker = $suspendReqData->actionTracker;
            if ($actionTracker) {
            // $suspendReqBy = $suspendReqData->actionTracker->FIRST_NAME.' '.$suspendReqData->actionTracker->LAST_NAME;
            $suspendReqBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        if(isset($ptwdetails->suspendby) && in_array($ptwdetails->STAGE_ID,[11])){
            $suspendData = $ptwdetails->suspendby->first();
            $actionTracker = $suspendData->actionTracker;
            if ($actionTracker) {
            // $suspendBy = $suspendData->actionTracker->FIRST_NAME.' '.$suspendData->actionTracker->LAST_NAME;
            $suspendBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        return [
            'ID' => $ptwdetails->ID,
            'PTW_ID' => $ptwdetails->ID,
            'AUTO_GEN_REF_NO' => $ptwdetails->AUTO_GEN_REF_NO,
            'SITE_NAME' => $ptwdetails->site->SITE_NAME,
            'SITE_ID' => $ptwdetails->SITE_ID,
            'TYPE_NAME' => $ptwdetails->type->TYPE_NAME,
            'TYPE_ID' => $ptwdetails->TYPE_ID,
            'STATUS' => $ptwdetails->stage->STAGE_NAME,
            'STAGE_ID' => $ptwdetails->STAGE_ID,
            'TOP_PARENT_PTW_ID' => $ptwdetails->TOP_PARENT_PTW_ID,
            'PARENT_PTW_ID' => $ptwdetails->PARENT_PTW_ID,
            'RENEWAL_COUNT' => $ptwdetails->RENEWAL_COUNT,
            'LOCATION_NAME' => $ptwdetails->location->LOCATION_NAME,
            'LOCATION_ID' => $ptwdetails->LOCATION_ID,                       
            'DESCRIPTION' => $ptwdetails->DESCRIPTION,
            'IS_CONTRACTOR_INFO_REQUIRED' => ($ptwdetails->IS_CONTRACTOR_INFO_REQUIRED == 1) ? "Yes" : "No",
            'CONTRACTOR_NAME' => ($ptwdetails->IS_CONTRACTOR_INFO_REQUIRED == 1)?$ptwdetails->contractor->CONTRACTOR_NAME:"",
            'IS_ISOLATION_REQUIRED' => ($ptwdetails->IS_ISOLATION_REQUIRED == 1) ? "Yes" : "No",
            'REMARKS' => $ptwdetails->REMARKS,
            'PERMIT_START_TIME' =>  showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")),
            'PERMIT_END_TIME' => showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")),
            'SPRINKLER_PROTECTION' => ($ptwdetails->SPRINKLER_PROTECTION == 1) ? "Yes" : "No",
            'SMOKE_DETECTION' => ($ptwdetails->SMOKE_DETECTION == 1) ? "Yes" : "No",
            'ON_A_ROOF' => ($ptwdetails->ON_A_ROOF == 1) ? "Yes" : "No", 
            'VERSION_DATE' => showDate($ptwdetails->CREATED_ON, config("constants.DATE_FORMAT")), 
            // 'PREPARED_BY' => $ptwdetails->preparedby->FIRST_NAME.' '.$ptwdetails->preparedby->LAST_NAME,
            'PREPARED_BY' => ($ptwdetails->preparedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($ptwdetails->preparedby->FIRST_NAME) . ' ' . $this->customDecrypt($ptwdetails->preparedby->LAST_NAME)) : "-",
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REVIEWED_BY' => $reviewedBy,
            'CLOSED_REQUEST_BY' => $closedReqBy,
            'CLOSED_BY' => $closedBy,
            'SUSPEND_REQUEST_BY' => $suspendReqBy,
            'SUSPEND_BY' => $suspendBy,                 
        ];
    }

    public function transformPtwXlReport($ptwdetails)
    {
             
        $approvedBy = "";
        $approvedDate = "";
        if(isset($ptwdetails->approvedby) && in_array($ptwdetails->STAGE_ID,[5,7,8,10,11,13])){
            $approvedData = $ptwdetails->approvedby->first();
            $actionTracker = $approvedData->actionTracker;
            if ($actionTracker) {
            // $approvedBy = $approvedData->actionTracker->FIRST_NAME.' '.$approvedData->actionTracker->LAST_NAME;
            $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
            $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
        }
        $reviewedBy = "";
        if(isset($ptwdetails->reviewedby) && in_array($ptwdetails->STAGE_ID,[3,5,7,8,10,11,13])){
            $reviewdData = $ptwdetails->reviewedby->first();
            $actionTracker = $reviewdData->actionTracker;
            if ($actionTracker) {
            // $reviewedBy = $reviewdData->actionTracker->FIRST_NAME.' '.$reviewdData->actionTracker->LAST_NAME;
            $reviewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        $closedReqBy = "";
        $closedBy = "";
        $suspendBy = "";
        $suspendReqBy = "";
        if(isset($ptwdetails->closedrequestby) && in_array($ptwdetails->STAGE_ID,[7,8])){
            $closedReqData = $ptwdetails->closedrequestby->first();
            $actionTracker = $closedReqData->actionTracker;
            if ($actionTracker) {
            // $closedReqBy = $closedReqData->actionTracker->FIRST_NAME.' '.$closedReqData->actionTracker->LAST_NAME;
            $closedReqBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        if(isset($ptwdetails->closedby) && in_array($ptwdetails->STAGE_ID,[8])){
            $closedData = $ptwdetails->closedby->first();
            $actionTracker = $closedData->actionTracker;
            if ($actionTracker) {
            // $closedBy = $closedData->actionTracker->FIRST_NAME.' '.$closedData->actionTracker->LAST_NAME;
            $closedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        if(isset($ptwdetails->suspendby) && in_array($ptwdetails->STAGE_ID,[10,11])){
            $suspendReqData = $ptwdetails->suspendrequestby->first();
            $actionTracker = $suspendReqData->actionTracker;
            if ($actionTracker) {
            // $suspendReqBy = $suspendReqData->actionTracker->FIRST_NAME.' '.$suspendReqData->actionTracker->LAST_NAME;
            $suspendReqBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        if(isset($ptwdetails->suspendby) && in_array($ptwdetails->STAGE_ID,[11])){
            $suspendData = $ptwdetails->suspendby->first();
            $actionTracker = $suspendData->actionTracker;
            if ($actionTracker) {
            // $suspendBy = $suspendData->actionTracker->FIRST_NAME.' '.$suspendData->actionTracker->LAST_NAME;
            $suspendBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        return [
            'ID' => $ptwdetails->ID,
            'PTW_ID' => $ptwdetails->ID,
            'AUTO_GEN_REF_NO' => $ptwdetails->AUTO_GEN_REF_NO,
            'SITE_NAME' => $ptwdetails->site->SITE_NAME,
            'SITE_ID' => $ptwdetails->SITE_ID,
            'TYPE_NAME' => $ptwdetails->type->TYPE_NAME,
            'TYPE_ID' => $ptwdetails->TYPE_ID,
            'STATUS' => $ptwdetails->stage->STAGE_NAME,
            'STAGE_ID' => $ptwdetails->STAGE_ID,
            'TOP_PARENT_PTW_ID' => $ptwdetails->TOP_PARENT_PTW_ID,
            'PARENT_PTW_ID' => $ptwdetails->PARENT_PTW_ID,
            'RENEWAL_COUNT' => $ptwdetails->RENEWAL_COUNT,
            'LOCATION_NAME' => $ptwdetails->location->LOCATION_NAME, 
            'LOCATION_ID' => $ptwdetails->LOCATION_ID,                      
            'DESCRIPTION' => $ptwdetails->DESCRIPTION,
            'IS_CONTRACTOR_INFO_REQUIRED' => ($ptwdetails->IS_CONTRACTOR_INFO_REQUIRED == 1) ? "Yes" : "No",
            'CONTRACTOR_NAME' => ($ptwdetails->IS_CONTRACTOR_INFO_REQUIRED == 1)?$ptwdetails->contractor->CONTRACTOR_NAME:"",
            'IS_ISOLATION_REQUIRED' => ($ptwdetails->IS_ISOLATION_REQUIRED == 1) ? "Yes" : "No",
            'REMARKS' => $ptwdetails->REMARKS,
            'PERMIT_START_TIME' =>  showDate($ptwdetails->PERMIT_START_TIME, config("constants.EXCEL_DATE_TIME_FORMAT")),
            'PERMIT_END_TIME' => showDate($ptwdetails->PERMIT_END_TIME, config("constants.EXCEL_DATE_TIME_FORMAT")),
            'SPRINKLER_PROTECTION' => ($ptwdetails->SPRINKLER_PROTECTION == 1) ? "Yes" : "No",
            'SMOKE_DETECTION' => ($ptwdetails->SMOKE_DETECTION == 1) ? "Yes" : "No",
            'ON_A_ROOF' => ($ptwdetails->ON_A_ROOF == 1) ? "Yes" : "No", 
            'VERSION_DATE' => showDate($ptwdetails->CREATED_ON, config("constants.EXCEL_DATE_FORMAT")), 
            // 'PREPARED_BY' => $ptwdetails->preparedby->FIRST_NAME.' '.$ptwdetails->preparedby->LAST_NAME,
            'PREPARED_BY' => ($ptwdetails->preparedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($ptwdetails->preparedby->FIRST_NAME) . ' ' . $this->customDecrypt($ptwdetails->preparedby->LAST_NAME)) : "-",
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REVIEWED_BY' => $reviewedBy,
            'CLOSED_REQUEST_BY' => $closedReqBy,
            'CLOSED_BY' => $closedBy,
            'SUSPEND_REQUEST_BY' => $suspendReqBy,
            'SUSPEND_BY' => $suspendBy,                 
        ];
    }


    public function transformPtwDownloadableList($ptwDownloadableData)
    {
        $requestedDate = "";
        $requesterName = "";
        $reviewedDate = "";
        $reviewerName = "";
        $approvedDate = "";
        $approverName = "";
        $rejectedDate = "";
        $rejecterName = "";
        $closedDate = "";
        $closerName = "";
        $suspendedDate = "";
        $suspenderName = "";

        if ($ptwDownloadableData->relationLoaded('actionRequestedHistory')
                 && $ptwDownloadableData->actionRequestedHistory) {
        $firstRequestedHistory = $ptwDownloadableData->actionRequestedHistory->first();
            if ($firstRequestedHistory) {
                $requestedDate = showDate($firstRequestedHistory->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT"));
                $actionTracker = $firstRequestedHistory->actionTracker;
                if ($actionTracker) {
                    $requesterName = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                }
            }
        }

        if ($ptwDownloadableData->relationLoaded('actionReviewedHistory')
                 && $ptwDownloadableData->actionReviewedHistory) {
        $firstReviewedHistory = $ptwDownloadableData->actionReviewedHistory->first();
            if ($firstReviewedHistory) {
                $reviewedDate = showDate($firstReviewedHistory->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT"));
                $actionTracker = $firstReviewedHistory->actionTracker;
                if ($actionTracker) {
                    $reviewerName = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                }
            }
        }

        if ($ptwDownloadableData->relationLoaded('actionApprovedHistory')
                 && $ptwDownloadableData->actionApprovedHistory) {
        $firstApprovedHistory = $ptwDownloadableData->actionApprovedHistory->first();
            if ($firstApprovedHistory) {
                $approvedDate = showDate($firstApprovedHistory->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT"));
                $actionTracker = $firstApprovedHistory->actionTracker;
                if ($actionTracker) {
                    $approverName = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                }
            }
        }

        if ($ptwDownloadableData->relationLoaded('actionRejectedHistory')
                 && $ptwDownloadableData->actionRejectedHistory) {
        $firstRejectedHistory = $ptwDownloadableData->actionRejectedHistory->first();
            if ($firstRejectedHistory) {
                $rejectedDate = showDate($firstRejectedHistory->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT"));
                $actionTracker = $firstRejectedHistory->actionTracker;
                if ($actionTracker) {
                    $rejecterName = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                }
            }
        }

        if ($ptwDownloadableData->relationLoaded('actionClosedHistory')
                 && $ptwDownloadableData->actionClosedHistory) {
        $firstClosedHistory = $ptwDownloadableData->actionClosedHistory->first();
            if ($firstClosedHistory) {
                $closedDate = showDate($firstClosedHistory->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT"));
                $actionTracker = $firstClosedHistory->actionTracker;
                if ($actionTracker) {
                    $closerName = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                }
            }
        }

        if ($ptwDownloadableData->relationLoaded('actionSuspendedHistory')
                 && $ptwDownloadableData->actionSuspendedHistory) {
        $firstSuspendedHistory = $ptwDownloadableData->actionSuspendedHistory->first();
            if ($firstSuspendedHistory) {
                $suspendedDate = showDate($firstSuspendedHistory->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT"));
                $actionTracker = $firstSuspendedHistory->actionTracker;
                if ($actionTracker) {
                    $suspenderName = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                }
            }
        }
        return [
            "PTW_ID"            => $ptwDownloadableData->ID,
            "AUTO_GEN_REF_NO"   => $ptwDownloadableData->AUTO_GEN_REF_NO,
            "TYPE_NAME"         => $ptwDownloadableData->type->TYPE_NAME,
            "CURR_STATE"        => ($ptwDownloadableData->RENEWAL_COUNT == 0) ? "Initial" : $ptwDownloadableData->RENEWAL_COUNT." Approval",
            "PERMIT_START_TIME" => showDate($ptwDownloadableData->PERMIT_START_TIME, config("constants.EXCEL_DATE_TIME_FORMAT")),
            "PERMIT_END_TIME"   => showDate($ptwDownloadableData->PERMIT_END_TIME, config("constants.EXCEL_DATE_TIME_FORMAT")),
            "LOCATION_NAME"     => $ptwDownloadableData->location->LOCATION_NAME,
            "STAGE_NAME"        => $ptwDownloadableData->stage->STAGE_NAME,
            // Additional data from action history
            "INITIATED_DATE"    => $requestedDate,
            "INITIATED_BY"      => $requesterName,
            "REVIEWED_DATE"     => $reviewedDate,
            "REVIEWED_BY"       => $reviewerName,
            "APPROVED_DATE"     => $approvedDate,
            "APPROVED_BY"       => $approverName,
            "REJECTED_DATE"     => $rejectedDate,
            "REJECTED_BY"       => $rejecterName,
            "CLOSED_DATE"       => $closedDate,
            "CLOSED_BY"         => $closerName,
            "SUSPENDED_DATE"    => $suspendedDate,
            "SUSPENDED_BY"      => $suspenderName
        ];
    }

}
