<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class PtwMapPrecResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $vvsPtwAction = [1=>"Tagged",2=>"Locked",3=>"Removed",4=>"Unlocked"];
        return [
            'TAG_NO'             => $this->TAG_NO,
            //'DEVICE'             => $this->DEVICE,
            'LOCATION'           => $this->LOCATION,
            'TAGGED_BY'           => [
                                        'KEY'   => $this->TAGGED_BY,
                                        // 'VALUE' => $this->taggedby->FIRST_NAME.' '.$this->taggedby->LAST_NAME,
                                        'VALUE' => ($this->taggedby->IS_INFO_REDUCTED == 0 ) ?
                                        ($this->customDecrypt($this->taggedby->FIRST_NAME)." ".$this->customDecrypt($this->taggedby->LAST_NAME))
                                        :"-",
                                    ],
            'TAGGED_ON'          => ($this->TAGGED_ON != "") ? showDate($this->TAGGED_ON,"Y-m-d H:i:s") : "",
            'ACTION_ID'          => [
                                        'KEY'   => $this->ACTION_ID,
                                        'VALUE' => $vvsPtwAction[$this->ACTION_ID] ?? ""
                                    ]
        ];
    }

    


}
