<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class PtwMapPrecReportResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $vvsPtwAction = [1=>"Tagged",2=>"Locked",3=>"Removed",4=>"Unlocked"];
        return [
            'TAG_NO'    => $this->TAG_NO,
            //'DEVICE'  => $this->DEVICE,
            'LOCATION'  => $this->LOCATION,
            // 'TAGGED_BY' => $this->taggedby->FIRST_NAME.' '.$this->taggedby->LAST_NAME,
            'TAGGED_BY' => ($this->taggedby->IS_INFO_REDUCTED == 0 ) ?
            ($this->customDecrypt($this->taggedby->FIRST_NAME)." ".$this->customDecrypt($this->taggedby->LAST_NAME))
            :"-",
            'TAGGED_ON' => ($this->TAGGED_ON != "") ? showDate($this->TAGGED_ON, config("constants.EXCEL_DATE_TIME_FORMAT")) : "",
            'ACTION_ID' => $vvsPtwAction[$this->ACTION_ID] ?? ""
        ];
    }

    


}
