<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class PtwActionHistoryResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'PTW_ID' => $this->PTW_ID,
            'ACTION' => $this->stage->STAGE_NAME,
            // 'ACTION_TAKEN_BY' => $this->actionTracker->FIRST_NAME.' '.$this->actionTracker->LAST_NAME,
            'ACTION_TAKEN_BY' => ($this->actionTracker->IS_INFO_REDUCTED == 0 ) ?
            ($this->customDecrypt($this->actionTracker->FIRST_NAME)." ".$this->customDecrypt($this->actionTracker->LAST_NAME))
            :"-",
            'COMMENTS' => $this->COMMENTS,
            'ACTION_TAKEN_ON' => ($this->CREATED_ON != "") ? showDate($this->CREATED_ON,"Y-m-d H:i:s") : "",

        ];
    }

    public function transformPtwAHXlReport($ptwActivityLog)
    {
        $actionBy = "";
        $actionTracker = $ptwActivityLog->actionTracker;
        if ($actionTracker) {
            $actionBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
        }
        return [
            'PTW_ID' => $ptwActivityLog->PTW_ID,
            'ACTION' => $ptwActivityLog->stage->STAGE_NAME,
            'ACTION_TAKEN_BY' => $actionBy,
            'COMMENTS' => $ptwActivityLog->COMMENTS,
            'ACTION_TAKEN_ON' => ($ptwActivityLog->CREATED_ON != "") ? showDate($ptwActivityLog->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT")) : "",

        ];
    }
}
