<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LocationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $value = '';
        
        if (!empty($this->LOCATION_NAME)) {
            $value .= $this->LOCATION_NAME;
        }
        
        if (!empty($this->BUILDING)) {
            $value .= ' | ' . $this->BUILDING;
        }
        
        if (!empty($this->FLOOR)) {
            $value .= ' | ' . $this->FLOOR;
        }

        if (!empty($this->WING)) {
            $value .= ' | ' . $this->WING;
        }

        if (!empty($this->DEPARTMENT)) {
            $value .= ' | ' . $this->DEPARTMENT;
        }

        if (!empty($this->CHECKLIST)) {
            $value .= ' | ' . $this->CHECKLIST;
        }

        if (!empty($this->QR_CODE)) {
            $value .= ' | ' . $this->QR_CODE;
        }
        return [
            'KEY' => $this->LOCATION_ID,
            'VALUE' => $value,
        ];
    }
}
