<?php

namespace App\Http\Resources\OBSERVATION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use DateTime;
use App\Http\Traits\EncDecService;

class ObservationResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "OBS_ID"           => $this->ID,
            "TYPE_NAME"       => $this->obstype->OBS_TYPE_NAME,
            "OBSERVATION_REFERENCE_NO" => $this->OBSERVATION_REFERENCE_NO,
            "DESCRIPTION"       => $this->DESCRIPTION,           
            "OBS_START_DATE"    => showDate($this->OBS_START_DATE, config("constants.DATE_FORMAT")),
            "OBS_END_DATE"      => showDate($this->OBS_END_DATE, config("constants.DATE_FORMAT")),            
            "LOCATION_NAME"     => (isset($this->location)?$this->location->LOCATION_NAME:""),
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"        => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "SEVERITY_ID"       => $this->SEVERITY_ID,
            "SEVERITY_NAME"     => (isset($this->severity)?$this->severity->SEVERITY_NAME:""),
            "LIKELIHOOD_ID"     => $this->LIKELIHOOD_ID,
            "LIKELIHOOD_NAME"   => (isset($this->likelihood)?$this->likelihood->LIKELIHOOD_NAME:""),
            "RISK_FACTOR"       => ((isset($this->severity) && isset($this->likelihood))?($this->severity->SEVERITY_NAME.$this->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_COLOUR"=> ((isset($this->severity) && isset($this->likelihood))?getSeverityLikehoodColor($this->severity->SEVERITY_NAME,$this->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_STAGE" => ((isset($this->severity) && isset($this->likelihood))?getSeverityLikehoodStage($this->severity->SEVERITY_NAME,$this->likelihood->LIKELIHOOD_NAME):""),
            "IS_DELETE_BTN"     => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)            
        ];
    }

    public static function transformObservation($observationdetails, $vvsUserData, $action = null)
    {
        
         if (!isset($action)) {
            $action = "";
        }        
        $editable = $observationdetails->STAGE_ID == 1 && $action !== 'view';
        $completeEditable = ((in_array($observationdetails->STAGE_ID,[4,5,9]) 
                            && ($observationdetails->ACTION_OWNER_ID == $vvsUserData->ID)
                            && $action !== 'view')?true:false);        
        return [
            'ID' => ["EDITABLE" => false, "VALUE" => $observationdetails->ID],
            'OBS_ID' => ["EDITABLE" => false, "VALUE" => $observationdetails->ID],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $observationdetails->SITE_ID],
            'OBSERVATION_REFERENCE_NO' => ["EDITABLE" => false, "VALUE" => $observationdetails->OBSERVATION_REFERENCE_NO],
            'LOCATION_ID' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->LOCATION_ID],
            'OBS_START_DATE' => ["EDITABLE" => $editable, "VALUE" => showDate($observationdetails->OBS_START_DATE, config("constants.DATE_TIME_FORMAT"))],
            'OBS_END_DATE' => ["EDITABLE" => $editable, "VALUE" => showDate($observationdetails->OBS_END_DATE, config("constants.DATE_TIME_FORMAT"))],
            'OBS_TYPE_ID' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->OBS_TYPE_ID],
            'REPORTED_BY_ID' => ["EDITABLE" => false, "VALUE" => $observationdetails->REPORTED_BY_ID],
            'REPORTED_BY_NAME' => ["EDITABLE" => false, "VALUE" => $observationdetails->REPORTED_BY_ID],
            'DESCRIPTION' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->DESCRIPTION],
            'SEVERITY_ID' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->SEVERITY_ID],
            'LIKELIHOOD_ID' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->LIKELIHOOD_ID],
            'ACTION_OWNER_ID' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->ACTION_OWNER_ID],
            'TARGET_TIMELINE' => ["EDITABLE" => $editable, "VALUE" => (isset($observationdetails->TARGET_TIMELINE)?showDate($observationdetails->TARGET_TIMELINE, config("constants.DATE_TIME_FORMAT")):"")],
            'RECOMMENDATION' => ["EDITABLE" => $editable, "VALUE" => $observationdetails->RECOMMENDATION],
            'ACTION_COMPLETED_DATE' => ["EDITABLE" => $completeEditable, "VALUE" => (isset($observationdetails->ACTION_COMPLETED_DATE)?showDate($observationdetails->ACTION_COMPLETED_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'ACTION_TAKEN_DETAILS' => ["EDITABLE" => $completeEditable, "VALUE" => $observationdetails->ACTION_TAKEN_DETAILS],
            'REVISE_TIMELINE' => ["EDITABLE" => $editable, "VALUE" => (isset($observationdetails->REVISE_TIMELINE)?showDate($observationdetails->REVISE_TIMELINE, config("constants.DATE_TIME_FORMAT")):"")],
            "RISK_FACTOR"       => ["EDITABLE" => false, "VALUE" => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?($observationdetails->severity->SEVERITY_NAME.$observationdetails->likelihood->LIKELIHOOD_NAME):"")],
            "RISK_FACTOR_COLOUR"=> ["EDITABLE" => false, "VALUE" => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?getSeverityLikehoodColor($observationdetails->severity->SEVERITY_NAME,$observationdetails->likelihood->LIKELIHOOD_NAME):"")],
            "RISK_FACTOR_STAGE" => ["EDITABLE" => false, "VALUE" => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?getSeverityLikehoodStage($observationdetails->severity->SEVERITY_NAME,$observationdetails->likelihood->LIKELIHOOD_NAME):"")],
            'STATUS' => ["EDITABLE" => false, "VALUE" => $observationdetails->stage->STAGE_NAME]
        ];
    }

    public function transformObservationReport($observationdetails, $action = null)
    {
        $vvsObservationFiles = $observationdetails->observationFiles;
        $vvsActionTakenFiles = $observationdetails->actionTakenFiles;
        $vvsstageId = $observationdetails->STAGE_ID;
        $vvsaction = null;
        $vvsObservationFileArray = [];
        $vvsActionTakenFileArray = [];

        $vvsUploadPath = config('constants.OBS_FILE_UPLOAD_PATH');
        $vvsUploadPath2 = config('constants.OBS_FILE_UPLOAD_PATH');

        if (!empty($vvsObservationFiles)) {
            foreach ($vvsObservationFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsObservationFileArray[$key1][$key2] = $value2;
                    if ($key2 == 'FILE_NAME') {
                        
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsurlArray = explode(".", $vvsImagePath);
                        $vvsurlLastElement = end($vvsurlArray);
                        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
                            $vvsObservationFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                            $vvsObservationFileArray[$key1]['OBSERVATION_FILE'] = $vvsImagePath;
                            $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = 'image';
                            // $vvsObservationFileArray[$key1]['IS_DELETE'] = ((in_array($vvsObservationData->STAGE_ID,[1]) && ($vvsObservationData->CREATED_BY == $userId))?true:false);
                        // }elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
                        //     $vvsObservationFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        //     $vvsObservationFileArray[$key1]['OBSERVATION_FILE'] = $vvsImagePath;
                        //     $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = 'application/pdf';
                        } else{
                            $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = 'not a image';
                        }
                    }
                }
            }
        }
        if (!empty($vvsActionTakenFiles)) {
            foreach ($vvsActionTakenFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsActionTakenFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath2 . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsurlArray = explode(".", $vvsImagePath);
                        $vvsurlLastElement = end($vvsurlArray);
                        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
                        $vvsActionTakenFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath2, '', $value2);
                        $vvsActionTakenFileArray[$key1]['ACTION_TAKEN_FILE'] = $vvsImagePath;
                        $vvsActionTakenFileArray[$key1]['MEDIA_TYPE_NAME'] = 'image';
                        // $vvsActionTakenFileArray[$key1]['IS_DELETE'] = ((in_array($vvsObservationData->STAGE_ID,[4,5,6]) && ($vvsObservationData->ACTION_OWNER_ID == $userId))?true:false);
                        // }elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
                        //     $vvsActionTakenFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath2, '', $value2);
                        //     $vvsActionTakenFileArray[$key1]['ACTION_TAKEN_FILE'] = $vvsImagePath;
                        //     $vvsActionTakenFileArray[$key1]['MEDIA_TYPE_NAME'] = 'application/pdf';
                        } else{
                            $vvsActionTakenFileArray[$key1]['MEDIA_TYPE_NAME'] = 'not a image or pdf';
                        }
                    }
                }
            }
        }
        $filteredObservationFiles = array_filter($vvsObservationFileArray, function($item) {
        return $item['MEDIA_TYPE_NAME'] === 'image';
        });
        
        // Filter Action Taken Files for Images
        $filteredActionTakenFiles = array_filter($vvsActionTakenFileArray, function($item) {
        return $item['MEDIA_TYPE_NAME'] === 'image';
        });

        $formattedStartDate = showDate($observationdetails->OBS_START_DATE, config("constants.EXCEL_DATE_FORMAT"));
        $formattedEndDate = showDate($observationdetails->OBS_END_DATE, config("constants.EXCEL_DATE_FORMAT"));

        // Concatenate the two date strings with some delimiter, e.g., " to ".
        $observationDate = $formattedStartDate . " to " . $formattedEndDate;

        $reportedBy = "";
        $reportedDate = "";
        if(isset($observationdetails->reportedbyhistory)){
            $reportedData = $observationdetails->reportedbyhistory->first();
            if ($reportedData) {
                if(isset($reportedData->actionTracker)){
                    $actionTracker = $reportedData->actionTracker;
                    if ($actionTracker) {
                    $reportedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $reportedBy = $reportedData->actionTracker->FIRST_NAME.' '.$reportedData->actionTracker->LAST_NAME;
                }
                if (isset($reportedData->CREATED_ON)) {
                    $reportedDate = showDate($reportedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $approvedBy = "";
        $approvedDate = "";
        if(isset($observationdetails->approvedbyhistory)){
            $approvedData = $observationdetails->approvedbyhistory->first();
            if ($approvedData) {
                if (isset($approvedData->actionTracker)) {
                    $actionTracker = $approvedData->actionTracker;
                    if ($actionTracker) {
                    $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $approvedBy = $approvedData->actionTracker->FIRST_NAME . ' ' . $approvedData->actionTracker->LAST_NAME;
                }
                if (isset($approvedData->CREATED_ON)) {
                    $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        if(isset($observationdetails->approvedbyhistory2)){
            $approvedData = $observationdetails->approvedbyhistory2->first();
            if ($approvedData) {
                if (isset($approvedData->actionTracker)) {
                    $actionTracker = $approvedData->actionTracker;
                    if ($actionTracker) {
                    $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $approvedBy = $approvedData->actionTracker->FIRST_NAME . ' ' . $approvedData->actionTracker->LAST_NAME;
                }
                if (isset($approvedData->CREATED_ON)) {
                    $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $closedBy = "";
        $closedDate = "";
        if(isset($observationdetails->closedbyhistory)){
            $closedData = $observationdetails->closedbyhistory->first();
            if ($closedData) {
                if (isset($closedData->actionTracker)) {
                    $actionTracker = $closedData->actionTracker;
                    if ($actionTracker) {
                    $closedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $closedBy = $closedData->actionTracker->FIRST_NAME . ' ' . $closedData->actionTracker->LAST_NAME;
                }
                if (isset($closedData->CREATED_ON)) {
                    $closedDate = showDate($closedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }

        $tat = "";
        if (in_array($observationdetails->STAGE_ID, [5, 9, 7, 8]) && isset($observationdetails->TARGET_TIMELINE) && isset($observationdetails->CREATED_ON)){
            $tat = self::calculateTAT($observationdetails->TARGET_TIMELINE, $observationdetails->CREATED_ON);
        }


        return [
            'ID' => $observationdetails->ID,
            'OBS_ID' => $observationdetails->ID,
            'SITE_NAME' => $observationdetails->site->SITE_NAME,
            'OBSERVATION_REFERENCE_NO' =>$observationdetails->OBSERVATION_REFERENCE_NO,
            'LOCATION_NAME' => $observationdetails->location ? $observationdetails->location->LOCATION_NAME : "",
            'OBS_DATE' =>   $observationDate,
            'OBS_TYPE_NAME' => $observationdetails->obstype->OBS_TYPE_NAME,
            // 'REPORTED_BY_NAME' => $observationdetails->reportedBy->FIRST_NAME.' '.$observationdetails->reportedBy->LAST_NAME,
            'REPORTED_BY_NAME' => ($observationdetails->reportedBy->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($observationdetails->reportedBy->FIRST_NAME) . ' ' . $this->customDecrypt($observationdetails->reportedBy->LAST_NAME)) : "-",
            'DESCRIPTION' => $observationdetails->DESCRIPTION,
            'SEVERITY_NAME' => $observationdetails->severity ? $observationdetails->severity->SEVERITY_NAME : "",
            'LIKELIHOOD_NAME' => $observationdetails->likelihood ? $observationdetails->likelihood->LIKELIHOOD_NAME : "",
            // 'ACTION_OWNER_NAME' => $observationdetails->actionOwner ? $observationdetails->actionOwner->FIRST_NAME.' '.$observationdetails->actionOwner->LAST_NAME : "",
            'ACTION_OWNER_NAME' => $observationdetails->actionOwner ? (($observationdetails->actionOwner->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($observationdetails->actionOwner->FIRST_NAME) . ' ' . $this->customDecrypt($observationdetails->actionOwner->LAST_NAME)) : "-") : "",
            'TARGET_TIMELINE' => (isset($observationdetails->TARGET_TIMELINE)?showDate($observationdetails->TARGET_TIMELINE, config("constants.EXCEL_DATE_FORMAT")):""),
            'RECOMMENDATION' => $observationdetails->RECOMMENDATION,
            'ACTION_COMPLETED_DATE' => (isset($observationdetails->ACTION_COMPLETED_DATE)?showDate($observationdetails->ACTION_COMPLETED_DATE, config("constants.EXCEL_DATE_FORMAT")):""),
            'ACTION_TAKEN_DETAILS' => $observationdetails->ACTION_TAKEN_DETAILS,
            'REVISE_TIMELINE' => (isset($observationdetails->REVISE_TIMELINE)?showDate($observationdetails->REVISE_TIMELINE, config("constants.EXCEL_DATE_FORMAT")):""),
            "RISK_FACTOR"       => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?($observationdetails->severity->SEVERITY_NAME.$observationdetails->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_COLOUR"=> ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?getSeverityLikehoodColor($observationdetails->severity->SEVERITY_NAME,$observationdetails->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_STAGE" => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?getSeverityLikehoodStage($observationdetails->severity->SEVERITY_NAME,$observationdetails->likelihood->LIKELIHOOD_NAME):""),
            'STATUS' => $observationdetails->stage->STAGE_NAME,
            'STATUS_COLOR_CODE' => $observationdetails->stage->COLOR_CODE,
            'ACCEPTED_TIMELINE_BY' => $approvedBy,
            'ACCEPTED_TIMELINE_ON' => $approvedDate,
            'REPORTED_BY' => $reportedBy,
            'REPORTED_DATE' => $reportedDate,
            'CLOSED_BY' => $closedBy,
            'CLOSED_DATE' => $closedDate,
            "OBSERVATION_FILES" => $filteredObservationFiles,
            "ACTION_TAKEN_FILES" => $filteredActionTakenFiles,
            'TAT' => $tat
        ];
    }

    public function transformObservationListReport($observationdetails, $action = null)
    {
        $vvsObservationFiles = $observationdetails->observationFiles;
        $vvsActionTakenFiles = $observationdetails->actionTakenFiles;
        $vvsstageId = $observationdetails->STAGE_ID;
        $vvsaction = null;
        $vvsObservationFileArray = [];
        $vvsActionTakenFileArray = [];

        $vvsUploadPath = config('constants.OBS_FILE_UPLOAD_PATH');
        $vvsUploadPath2 = config('constants.OBS_FILE_UPLOAD_PATH');

        if (!empty($vvsObservationFiles)) {
            foreach ($vvsObservationFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsObservationFileArray[$key1][$key2] = $value2;
                    if ($key2 == 'FILE_NAME') {
                        
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsurlArray = explode(".", $vvsImagePath);
                        $vvsurlLastElement = end($vvsurlArray);
                        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
                        $vvsObservationFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        $vvsObservationFileArray[$key1]['OBSERVATION_FILE'] = $vvsImagePath;
                        $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = 'image';
                        // $vvsObservationFileArray[$key1]['IS_DELETE'] = ((in_array($vvsObservationData->STAGE_ID,[1]) && ($vvsObservationData->CREATED_BY == $userId))?true:false);
                        } else{
                            $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = 'not a image';
                        }
                    }
                }
            }
        }
        if (!empty($vvsActionTakenFiles)) {
            foreach ($vvsActionTakenFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsActionTakenFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath2 . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsurlArray = explode(".", $vvsImagePath);
                        $vvsurlLastElement = end($vvsurlArray);
                        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
                        $vvsActionTakenFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath2, '', $value2);
                        $vvsActionTakenFileArray[$key1]['ACTION_TAKEN_FILE'] = $vvsImagePath;
                        $vvsActionTakenFileArray[$key1]['MEDIA_TYPE_NAME'] = 'image';
                        // $vvsActionTakenFileArray[$key1]['IS_DELETE'] = ((in_array($vvsObservationData->STAGE_ID,[4,5,6]) && ($vvsObservationData->ACTION_OWNER_ID == $userId))?true:false);
                        } else{
                            $vvsActionTakenFileArray[$key1]['MEDIA_TYPE_NAME'] = 'not a image';
                        }
                    }
                }
            }
        }
        $formattedStartDate = showDate($observationdetails->OBS_START_DATE, config("constants.EXCEL_DATE_TIME_FORMAT"));
        $formattedEndDate = showDate($observationdetails->OBS_END_DATE, config("constants.EXCEL_DATE_TIME_FORMAT"));

        // Concatenate the two date strings with some delimiter, e.g., " to ".
        $observationDate = $formattedStartDate . " to " . $formattedEndDate;

        $reportedBy = "";
        $reportedDate = "";
        if(isset($observationdetails->reportedbyhistory)){
            $reportedData = $observationdetails->reportedbyhistory->first();
            if ($reportedData) {
                if(isset($reportedData->actionTracker)){
                    $actionTracker = $reportedData->actionTracker;
                    if ($actionTracker) {
                    $reportedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $reportedBy = $reportedData->actionTracker->FIRST_NAME.' '.$reportedData->actionTracker->LAST_NAME;
                }
                if (isset($reportedData->CREATED_ON)) {
                    $reportedDate = showDate($reportedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $approvedBy = "";
        $approvedDate = "";
        if(isset($observationdetails->approvedbyhistory)){
            $approvedData = $observationdetails->approvedbyhistory->first();
            if ($approvedData) {
                if (isset($approvedData->actionTracker)) {
                    $actionTracker = $approvedData->actionTracker;
                    if ($actionTracker) {
                    $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $approvedBy = $approvedData->actionTracker->FIRST_NAME . ' ' . $approvedData->actionTracker->LAST_NAME;
                }
                if (isset($approvedData->CREATED_ON)) {
                    $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        if(isset($observationdetails->approvedbyhistory2)){
            $approvedData = $observationdetails->approvedbyhistory2->first();
            if ($approvedData) {
                if (isset($approvedData->actionTracker)) {
                    $actionTracker = $approvedData->actionTracker;
                    if ($actionTracker) {
                    $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $approvedBy = $approvedData->actionTracker->FIRST_NAME . ' ' . $approvedData->actionTracker->LAST_NAME;
                }
                if (isset($approvedData->CREATED_ON)) {
                    $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $closedBy = "";
        $closedDate = "";
        if(isset($observationdetails->closedbyhistory)){
            $closedData = $observationdetails->closedbyhistory->first();
            if ($closedData) {
                if (isset($closedData->actionTracker)) {
                    $actionTracker = $closedData->actionTracker;
                    if ($actionTracker) {
                    $closedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $closedBy = $closedData->actionTracker->FIRST_NAME . ' ' . $closedData->actionTracker->LAST_NAME;
                }
                if (isset($closedData->CREATED_ON)) {
                    $closedDate = showDate($closedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }

        $tat = "";
        if (in_array($observationdetails->STAGE_ID, [5, 9, 7, 8]) && isset($observationdetails->TARGET_TIMELINE) && isset($observationdetails->CREATED_ON)){
            $tat = self::calculateTAT($observationdetails->TARGET_TIMELINE, $observationdetails->CREATED_ON);
        }
        
        return [
            'ID' => $observationdetails->ID,
            'OBS_ID' => $observationdetails->ID,
            'SITE_NAME' => $observationdetails->site->SITE_NAME,
            'OBSERVATION_REFERENCE_NO' =>$observationdetails->OBSERVATION_REFERENCE_NO,
            'LOCATION_NAME' => $observationdetails->location ? $observationdetails->location->LOCATION_NAME : "",
            'OBS_DATE' =>   $observationDate,
            'OBS_TYPE_NAME' => $observationdetails->obstype->OBS_TYPE_NAME,
            // 'REPORTED_BY_NAME' => $observationdetails->reportedBy->FIRST_NAME.' '.$observationdetails->reportedBy->LAST_NAME,
            'REPORTED_BY_NAME' => ($observationdetails->reportedBy->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($observationdetails->reportedBy->FIRST_NAME) . ' ' . $this->customDecrypt($observationdetails->reportedBy->LAST_NAME)) : "-",
            'DESCRIPTION' => $observationdetails->DESCRIPTION,
            'SEVERITY_NAME' => $observationdetails->severity ? $observationdetails->severity->SEVERITY_NAME : "",
            'LIKELIHOOD_NAME' => $observationdetails->likelihood ? $observationdetails->likelihood->LIKELIHOOD_NAME : "",
            // 'ACTION_OWNER_NAME' => $observationdetails->actionOwner ? $observationdetails->actionOwner->FIRST_NAME.' '.$observationdetails->actionOwner->LAST_NAME : "",
            'ACTION_OWNER_NAME' => $observationdetails->actionOwner ? (($observationdetails->actionOwner->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($observationdetails->actionOwner->FIRST_NAME) . ' ' . $this->customDecrypt($observationdetails->actionOwner->LAST_NAME)) : "-") : "",
            'TARGET_TIMELINE' => (isset($observationdetails->TARGET_TIMELINE)?showDate($observationdetails->TARGET_TIMELINE, config("constants.EXCEL_DATE_TIME_FORMAT")):""),
            'RECOMMENDATION' => $observationdetails->RECOMMENDATION,
            'ACTION_COMPLETED_DATE' => (isset($observationdetails->ACTION_COMPLETED_DATE)?showDate($observationdetails->ACTION_COMPLETED_DATE, config("constants.EXCEL_DATE_TIME_FORMAT")):""),
            'ACTION_TAKEN_DETAILS' => $observationdetails->ACTION_TAKEN_DETAILS,
            'REVISE_TIMELINE' => (isset($observationdetails->REVISE_TIMELINE)?showDate($observationdetails->REVISE_TIMELINE, config("constants.EXCEL_DATE_TIME_FORMAT")):""),
            "RISK_FACTOR"       => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?($observationdetails->severity->SEVERITY_NAME.$observationdetails->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_COLOUR"=> ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?getSeverityLikehoodColor($observationdetails->severity->SEVERITY_NAME,$observationdetails->likelihood->LIKELIHOOD_NAME):""),
            "RISK_FACTOR_STAGE" => ((isset($observationdetails->severity) && isset($observationdetails->likelihood))?getSeverityLikehoodStage($observationdetails->severity->SEVERITY_NAME,$observationdetails->likelihood->LIKELIHOOD_NAME):""),
            'STATUS' => $observationdetails->stage->STAGE_NAME,
            'STATUS_COLOR_CODE' => $observationdetails->stage->COLOR_CODE,
            "OBSERVATION_FILES" => $vvsObservationFileArray,
            "ACTION_TAKEN_FILES" => $vvsActionTakenFileArray,
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REPORTED_BY' => $reportedBy,
            'REPORTED_DATE' => $reportedDate,
            'CLOSED_BY' => $closedBy,
            'CLOSED_DATE' => $closedDate,
            'TAT' => $tat
        ];
    }

    private static function calculateTAT($targetTimeline, $createdOn)
    {
        // Convert date strings to DateTime objects
        $targetDate = new DateTime($targetTimeline);
        $createdDate = new DateTime($createdOn);

        $targetDate->setTime(0, 0, 0);
        $createdDate->setTime(0, 0, 0);

         // Calculate the difference in days
        $difference = $targetDate->diff($createdDate)->days;

        // Format the result
        return "$difference days";

    }

    
}