<?php

namespace App\Http\Resources\OBSERVATION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class ObservationReportedByResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'KEY' => $this->user->ID,
            // 'VALUE' => $this->user->FIRST_NAME.' '.$this->user->LAST_NAME,
            'VALUE' => ($this->user->IS_INFO_REDUCTED == 0 ) ?
            ($this->customDecrypt($this->user->FIRST_NAME).' '.$this->customDecrypt($this->user->LAST_NAME)):"-",
        ];
    }
}
