<?php

namespace App\Http\Resources\OBSERVATION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ObservationMapDeclarationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'DECLARATION_ID'            => $this->DECLARATION_ID,
            'DECLARATION_NAME'          => $this->DECLARATION_NAME,
            'DECLARATION_SECTION'       => $this->DECLARATION_SECTION,
            'DECLARATION_GROUP'         => $this->DECLARATION_GROUP,
            'IS_CHECKED'                => ($this->MAP_DECLARATION_ID >0) ?
                                                (($this->IS_ACTIVE == 1 && $this->IS_DELETED == 0 ) ? true : false) :
                                                false
        ];
    }

    


}
