<?php

namespace App\Http\Resources\OBSERVATION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class ObservationActionHistoryResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'OBS_ID' => $this->OBS_ID,
            'ACTION' => $this->stage->STAGE_NAME,
            // 'ACTION_TAKEN_BY' => $this->actionTracker->FIRST_NAME.' '.$this->actionTracker->LAST_NAME,
            'ACTION_TAKEN_BY' => ($this->actionTracker->IS_INFO_REDUCTED == 0 ) ?
            ($this->customDecrypt($this->actionTracker->FIRST_NAME)." ".$this->customDecrypt($this->actionTracker->LAST_NAME))
            :"-",
            'ACTION_TAKEN_ON' => ($this->CREATED_ON != "") ? showDate($this->CREATED_ON,"Y-m-d H:i:s") : "",
            "COMMENTS" => $this->COMMENTS,

        ];
    }

    public function transformActionTakenReport($observationActionTaken)
    {
        return [
            'OBS_ID' => $observationActionTaken->OBS_ID,
            'ACTION' => $observationActionTaken->stage->STAGE_NAME,
            // 'ACTION_TAKEN_BY' => $this->actionTracker->FIRST_NAME.' '.$this->actionTracker->LAST_NAME,
            'ACTION_TAKEN_BY' => ($observationActionTaken->actionTracker->IS_INFO_REDUCTED == 0 ) ?
            ($this->customDecrypt($observationActionTaken->actionTracker->FIRST_NAME)." ".$this->customDecrypt($observationActionTaken->actionTracker->LAST_NAME))
            :"-",
            'ACTION_TAKEN_ON' => ($observationActionTaken->CREATED_ON != "") ? showDate($observationActionTaken->CREATED_ON, config("constants.EXCEL_DATE_TIME_FORMAT")) : "",

        ];
    }
}
