<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class MasterUserAccessResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'USER_ID'                  => $this->ID,
            // 'FIRST_NAME'               => $this->FIRST_NAME,
            'FIRST_NAME'               => ($this->IS_INFO_REDUCTED == 0 ) ? ($this->customDecrypt($this->FIRST_NAME)):"-",
            'LAST_NAME'                => ($this->IS_INFO_REDUCTED == 0 ) ? ($this->customDecrypt($this->LAST_NAME)):"-",
            // 'WORKER_AUTO_GEN_ID'    => $this->WORKER_AUTO_GEN_ID,
            // 'WORKER_DESG_NAME'      => $this->WORKER_DESG_NAME,
            // 'CONTRACTOR_NAME'       => $this->CONTRACTOR_NAME,
            'ROLE_NAME'             => $this->roles->pluck('userroles.ROLE_NAME')->implode(','),
            'SITE_NAME'             => $this->sites->pluck('site.SITE_NAME')->implode(','),
            'IS_EDIT_BTN'           => ($this->UserRole == 10) ? true : false,
            'IS_DELETE_BTN'         => ($this->UserRole == 10) ? true : false,
            'IS_ACTIVE_BTN'         => ($this->IS_ACTIVE == 0 && $this->UserRole == 10) ? true : false,
            'IS_INACTIVE_BTN'       => ($this->IS_ACTIVE == 1 && $this->UserRole == 10) ? true : false,
            // 'IS_APPROVE_BTN'        => ($this->IS_ACTIVE == 0 && $this->UserRole == 10) ? true : false,
            'STATUS_NAME'           => ($this->IS_ACTIVE == 1) ? 'Active' : 'Inactive',
            'STATUS_COLOR'          => ($this->IS_ACTIVE == 1) ? '#bcfa93' : '#f7d980',
            'STATUS_ALIAS'          => ($this->IS_ACTIVE == 1) ? 'ACT' : 'INA',
            'IS_ACTIVE'             => $this->IS_ACTIVE,
            'IS_DELETED'            => $this->IS_DELETED,
        ];
    }

    public function transformUser($userdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $userdetails->IS_ACTIVE == 0 && $action !== 'view';

        $roleDetails = [];
        $administratorPrivilege = 0;

        foreach ($userdetails->roles as $role) {
            if ($role->ROLE_ID == 10) {
                $administratorPrivilege = 1;
                break;
            } else {
                $roleDetails[] = [
                    'MODULE_NAME' => [
                        'KEY' => $role->MODULE_NAME,
                        'VALUE' => $role->MODULE_NAME
                    ],
                    'ROLE_ID' => [
                        'KEY' => $role->ROLE_ID,
                        'VALUE' => $role->userroles->ROLE_NAME
                    ],
                    // Add other role attributes as needed
                ];
            }
        }

        $siteDetails = [];
        foreach ($userdetails->sites as $site) {
            $siteDetails[] = $site->SITE_ID;
        }

        $response = [
            'USER_ID' => ["EDITABLE" => false, "VALUE" => $userdetails->ID],
            'EMAIL' => ["EDITABLE" => $editable, "VALUE" => $this->customDecrypt($userdetails->EMAIL)],
            'FIRST_NAME' => ["EDITABLE" => $editable, "VALUE" => $this->customDecrypt($userdetails->FIRST_NAME)],
            'LAST_NAME' => ["EDITABLE" => $editable, "VALUE" => $this->customDecrypt($userdetails->LAST_NAME)],
            'SITE_DTLS' => ["EDITABLE" => $editable, "VALUE" => $siteDetails],
            'STATUS' => ["EDITABLE" => true, "VALUE" => $userdetails->IS_ACTIVE],
            'ADMINISTRATOR_PRIVILEGE' => ["EDITABLE" => false, "VALUE" => $administratorPrivilege]
        ];

        if ($administratorPrivilege == 0) {
            $response['ROLE_DTLS'] = ["EDITABLE" => $editable, "VALUE" => $roleDetails];
        }

        return $response;
    }


    // public function transformUser($userdetails, $action = null)
    // {
    //     if (!isset($action)) {
    //         $action = "";
    //     }

    //     $editable = $userdetails->IS_ACTIVE == 0 && $action !== 'view';

    //     $roleDetails = [];
    //     foreach ($userdetails->roles as $role) {
    //         $roleDetails[] = [
    //             'MODULE_NAME' => [
    //                 'KEY' => $role->MODULE_NAME,
    //                 'VALUE' => $role->MODULE_NAME
    //             ],
    //             'ROLE_ID' => [
    //                 'KEY' => $role->ROLE_ID,
    //                 'VALUE' => $role->userroles->ROLE_NAME
    //             ],
    //             // Add other role attributes as needed
    //         ];
    //     }

    //     $siteDetails = [];
    //     foreach ($userdetails->sites as $site) {
    //             $siteDetails[] = $site->SITE_ID;
    //     }

    //     return [
    //         'USER_ID' => ["EDITABLE" => false, "VALUE" => $userdetails->ID],
    //         'EMAIL' => ["EDITABLE" => $editable, "VALUE" => $this->customDecrypt($userdetails->EMAIL)],
    //         'FIRST_NAME' => ["EDITABLE" => $editable, "VALUE" => $this->customDecrypt($userdetails->FIRST_NAME)],
    //         'LAST_NAME' => ["EDITABLE" => $editable, "VALUE" => $this->customDecrypt($userdetails->LAST_NAME)],
    //         'ROLE_DTLS' => ["EDITABLE" => $editable, "VALUE" =>$roleDetails ],
    //         'SITE_DTLS' => ["EDITABLE" => $editable, "VALUE" =>$siteDetails ],
    //         'STATUS' => ["EDITABLE" => true, "VALUE" =>$userdetails->IS_ACTIVE]
    //     ];
    // }
}
