<?php

namespace App\Http\Resources\Master;


use Illuminate\Http\Request;
use App\Models\MstRole;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterUserAccessMasterListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Skip processing if MODULE_NAME is 'MASTER'
        if ($this->MODULE_NAME === 'MASTER') {
            return [];
        }
        
        $roles = $this->getRoles();

        $formattedRoles = [];
        foreach ($roles as $role) {
            $formattedRoles[] = [
                'KEY' => $role['ROLE_ID'],
                'VALUE' => $role['ROLE_NAME']
            ];
        }

        // Return the transformed data
        return [
            'KEY' => $this->MODULE_NAME,
            'VALUE' => $this->MODULE_NAME,
            'ROLE' => $formattedRoles
        ];
    }

    /**
     * Get roles based on conditions.
     *
     * @return array
     */
    private function getRoles()
    {
        // Initialize an empty array to store roles
        $roles = [];

        if ($this->MODULE_NAME === 'PTW') {
            // Fetch roles with ROLE_ID 1, 2, or 3
            $roles = MstRole::whereIn('ROLE_ID', [1, 2, 3])->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->get(['ROLE_ID', 'ROLE_NAME'])->toArray();
        } elseif ($this->MODULE_NAME === 'HIRA') {
            // Fetch roles with ROLE_ID 4, 5, 6, or 13
            $roles = MstRole::whereIn('ROLE_ID', [4, 5, 6, 13])->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->get(['ROLE_ID', 'ROLE_NAME'])->toArray();
        } elseif ($this->MODULE_NAME === 'INSP') {
            // Fetch roles with ROLE_ID 7, 8, or 9
            $roles = MstRole::whereIn('ROLE_ID', [7, 8, 9])->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->get(['ROLE_ID', 'ROLE_NAME'])->toArray();
        // } elseif ($this->MODULE_NAME === 'MASTER') {
        //     // Fetch roles with ROLE_ID 10
        //     $roles = MstRole::whereIn('ROLE_ID', [10])->get(['ROLE_ID', 'ROLE_NAME'])->toArray();
        } elseif ($this->MODULE_NAME === 'OBS') {
            // Fetch roles with ROLE_ID 11, or 12
            $roles = MstRole::whereIn('ROLE_ID', [11, 12])->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->get(['ROLE_ID', 'ROLE_NAME'])->toArray();
        } elseif ($this->MODULE_NAME === 'TR') {
            // Fetch roles with ROLE_ID 14
            $roles = MstRole::whereIn('ROLE_ID', [14])->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->get(['ROLE_ID', 'ROLE_NAME'])->toArray();
        }

        return $roles;
    }
}
