<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterTypeTopicResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $topicMappings = [];
            foreach ($this->topicMappings as $topic) {
                $topicMappings[] = [
                    'TR_TOPIC_ID' => $topic->TR_TOPIC_ID,
                    'TR_TOPIC_NAME' => $topic->TR_TOPIC_NAME,
                ];
            }
        return [
            'TR_TYPE_ID'        => $this->TR_TYPE_ID,
            'TR_TYPE_NAME'      => $this->TR_TYPE_NAME,
            'TOPIC'             => $topicMappings,
            'CATEGORY'          => $this->CATEGORY,
            'IS_EDIT_BTN'       => ($this->UserRole == 10) ? true : false,
            'IS_DELETE_BTN'     => ($this->UserRole == 10) ? true : false,
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformTypeTopic($typetopicdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $typetopicdetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'TR_TOPIC_ID' => ["EDITABLE" => false, "VALUE" => $typetopicdetails->TR_TOPIC_ID],
            'TR_TOPIC_NAME' => ["EDITABLE" => true, "VALUE" => $typetopicdetails->TR_TOPIC_NAME],
            'TR_TYPE_ID' => ["EDITABLE" => true, "VALUE" => $typetopicdetails->TR_TYPE_ID]
        ];
    }
}