<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterSkillResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'TYPE_ID'           => $this->TYPE_ID,
            'TYPE_NAME'         => $this->TYPE_NAME,
            'IS_EDIT_BTN'       => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_APPROVE_BTN'    => ($this->IS_ACTIVE == 0 && $this->UserRole == 10) ? true : false,
            'STATUS_NAME'       => ($this->IS_ACTIVE == 1) ? 'Approved' : 'Not Approved',
            'STATUS_COLOR'      => ($this->IS_ACTIVE == 1) ? '#bcfa93' : '#f7d980',
            'STATUS_ALIAS'      => ($this->IS_ACTIVE == 1) ? 'AP' : 'NA',
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformSkill($skilldetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $skilldetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'TYPE_ID' => ["EDITABLE" => false, "VALUE" => $skilldetails->TYPE_ID],
            'TYPE_NAME' => ["EDITABLE" => $editable, "VALUE" => $skilldetails->TYPE_NAME],
        ];
    }
}