<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterSOPPolicyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'SOP_POLICY_ID'     => $this->SOP_POLICY_ID,
            'SOP_NAME'          => $this->NAME,
            'REFRENCE_NO'       => $this->REFRENCE_NO,
            'IS_EDIT_BTN'       => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_APPROVE_BTN'    => ($this->IS_ACTIVE == 0 && $this->UserRole == 10) ? true : false,
            'STATUS_NAME'       => ($this->IS_ACTIVE == 1) ? 'Approved' : 'Not Approved',
            'STATUS_COLOR'      => ($this->IS_ACTIVE == 1) ? '#bcfa93' : '#f7d980',
            'STATUS_ALIAS'      => ($this->IS_ACTIVE == 1) ? 'AP' : 'NA',
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformSOP($sopdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $sopdetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'SOP_POLICY_ID' => ["EDITABLE" => false, "VALUE" => $sopdetails->SOP_POLICY_ID],
            'NAME' => ["EDITABLE" => $editable, "VALUE" => $sopdetails->NAME],
            'REFRENCE_NO' => ["EDITABLE" => $editable, "VALUE" => $sopdetails->REFRENCE_NO],
        ];
    }
}