<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterRiskRelatedResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'RISK_RELATED_ID'   => $this->RISK_RELATED_ID,
            'RISK_RELATED_NAME' => $this->RISK_RELATED_NAME,
            'ACTIVITY_ID'       => $this->ACTIVITY_ID,
            'ACTIVITY_NAME'     => $this->activity->ACTIVITY_NAME,
            'IS_EDIT_BTN'       => ($this->RiskRelatedInUse == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->RiskRelatedInUse == 0) ? true : false,
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformRiskRelated($riskrelateddetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $riskrelateddetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'RISK_RELATED_ID' => ["EDITABLE" => false, "VALUE" => $riskrelateddetails->RISK_RELATED_ID],
            'RISK_RELATED_NAME' => ["EDITABLE" => true, "VALUE" => $riskrelateddetails->RISK_RELATED_NAME],
            'ACTIVITY_ID' => ["EDITABLE" => true, "VALUE" => $riskrelateddetails->ACTIVITY_ID]
        ];
    }
}