<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterLocationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'LOCATION_ID'       => $this->LOCATION_ID,
            'LOCATION_NAME'     => $this->LOCATION_NAME,
            'SITE_ID'           => $this->SITE_ID,
            'SITE_NAME'         => $this->site->SITE_NAME,
            'BUILDING'          => $this->BUILDING,
            'FLOOR'             => $this->FLOOR,
            'WING'              => $this->WING,
            'DEPARTMENT'        => $this->DEPARTMENT,
            'CHECKLIST'         => $this->CHECKLIST,
            'ASSIGNED_DEPT'     => $this->ASSIGNED_DEPT,
            'QR_CODE'           => $this->QR_CODE,
            'IS_EDIT_BTN'       => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_APPROVE_BTN'    => ($this->IS_ACTIVE == 0 && $this->UserRole == 10) ? true : false,
            'STATUS_NAME'       => ($this->IS_ACTIVE == 1) ? 'Approved' : 'Not Approved',
            'STATUS_COLOR'      => ($this->IS_ACTIVE == 1) ? '#bcfa93' : '#f7d980',
            'STATUS_ALIAS'      => ($this->IS_ACTIVE == 1) ? 'AP' : 'NA',
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED,
        ];
    }

    public static function transformLocation($locationdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $locationdetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'LOCATION_ID' => ["EDITABLE" => false, "VALUE" => $locationdetails->LOCATION_ID],
            'LOCATION_NAME' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->LOCATION_NAME],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $locationdetails->SITE_ID],
            'BUILDING' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->BUILDING],
            'FLOOR' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->FLOOR],
            'WING' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->WING],
            'DEPARTMENT' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->DEPARTMENT],
            'CHECKLIST' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->CHECKLIST],
            'ASSIGNED_DEPT' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->ASSIGNED_DEPT],
            'QR_CODE' => ["EDITABLE" => $editable, "VALUE" => $locationdetails->QR_CODE]
        ];
    }
}