<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterJobResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'JOB_ID'            => $this->JOB_ID,
            'JOB_NAME'          => $this->JOB_NAME,
            // 'SITE_ID'           => $this->SITE_ID,
            // 'SITE_NAME'         => $this->site->SITE_NAME,
            'IS_EDIT_BTN'       => ($this->JobInUse == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->JobInUse == 0) ? true : false,
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformJob($jobdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $jobdetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'JOB_ID' => ["EDITABLE" => false, "VALUE" => $jobdetails->JOB_ID],
            'JOB_NAME' => ["EDITABLE" => true, "VALUE" => $jobdetails->JOB_NAME]
        ];
    }
}