<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterContractorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'CONTRACTOR_ID'     => $this->CONTRACTOR_ID,
            'CONTRACTOR_NAME'   => $this->CONTRACTOR_NAME,
            'SITE_ID'           => $this->SITE_ID,
            'SITE_NAME'         => $this->site->SITE_NAME,
            'IS_EDIT_BTN'       => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->IS_ACTIVE == 0) ? true : false,
            'IS_APPROVE_BTN'    => ($this->IS_ACTIVE == 0 && $this->UserRole == 10) ? true : false,
            'STATUS_NAME'       => ($this->IS_ACTIVE == 1) ? 'Approved' : 'Not Approved',
            'STATUS_COLOR'      => ($this->IS_ACTIVE == 1) ? '#bcfa93' : '#f7d980',
            'STATUS_ALIAS'      => ($this->IS_ACTIVE == 1) ? 'AP' : 'NA',
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformContractor($contractordetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $contractordetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'CONTRACTOR_ID' => ["EDITABLE" => false, "VALUE" => $contractordetails->CONTRACTOR_ID],
            'CONTRACTOR_NAME' => ["EDITABLE" => $editable, "VALUE" => $contractordetails->CONTRACTOR_NAME],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $contractordetails->SITE_ID]
        ];
    }
}