<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterActivityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'ACTIVITY_ID'       => $this->ACTIVITY_ID,
            'ACTIVITY_NAME'     => $this->ACTIVITY_NAME,
            'JOB_ID'            => $this->JOB_ID,
            'JOB_NAME'          => $this->job->JOB_NAME,
            'IS_EDIT_BTN'       => ($this->ActivityInUse == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->ActivityInUse == 0) ? true : false,
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED
        ];
    }

    public static function transformActivity($activitydetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $activitydetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'ACTIVITY_ID' => ["EDITABLE" => false, "VALUE" => $activitydetails->ACTIVITY_ID],
            'ACTIVITY_NAME' => ["EDITABLE" => true, "VALUE" => $activitydetails->ACTIVITY_NAME],
            'JOB_ID' => ["EDITABLE" => true, "VALUE" => $activitydetails->JOB_ID]
        ];
    }
}