<?php

namespace App\Http\Resources\INSPECTION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class InspectionResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "INSP_ID"           => $this->ID,
            "TYPE_NAME"       => $this->type->INSP_TYPE_NAME,
            "INSPECTION_REFERENCE_NO" => $this->INSPECTION_REFERENCE_NO,
            "DESCRIPTION"       => $this->DESCRIPTION,           
            "INSP_DATE"         => showDate($this->INSP_DATE, config("constants.DATE_FORMAT")),            
            "LOCATION_NAME"     => (isset($this->location)?$this->location->LOCATION_NAME:""),
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"        => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "IS_DELETE_BTN"     => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)            
        ];
    }

    public static function transformInspection($inspectiondetails, $action = null)
    {
        
         if (!isset($action)) {
            $action = "";
        }        
        $editable = $inspectiondetails->STAGE_ID == 1 && $action !== 'view';
        return [
            'ID' => ["EDITABLE" => false, "VALUE" => $inspectiondetails->ID],
            'INSP_ID' => ["EDITABLE" => false, "VALUE" => $inspectiondetails->ID],
            'INSPECTION_REFERENCE_NO' => ["EDITABLE" => false, "VALUE" => $inspectiondetails->INSPECTION_REFERENCE_NO],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $inspectiondetails->SITE_ID],
            'LOCATION_ID' => ["EDITABLE" => true, "VALUE" => $inspectiondetails->LOCATION_ID],
            'TYPE_ID' => ["EDITABLE" => false, "VALUE" => $inspectiondetails->TYPE_ID],
            'STATUS' => ["EDITABLE" => false, "VALUE" => $inspectiondetails->stage->STAGE_NAME],
            'DESCRIPTION' => ["EDITABLE" => $editable, "VALUE" => $inspectiondetails->DESCRIPTION],
            'INSP_DATE' => ["EDITABLE" => $editable, "VALUE" => showDate($inspectiondetails->INSP_DATE, config("constants.DATE_TIME_FORMAT"))],
            'USER_ID' => ["EDITABLE" => $editable, "VALUE" => $inspectiondetails->mapRecipent->pluck('USER_ID')],           
        ];
    }

    public function transformInspectionReport($inspectiondetails)
    {
        $reportedBy = "";
        $reportedDate = "";
        if (isset($inspectiondetails->reportedby) && in_array($inspectiondetails->STAGE_ID, [2])) {
            $reportedData = $inspectiondetails->reportedby->first();
            $actionTracker = $reportedData->actionTracker;
            if ($actionTracker) {
            $reportedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
            // $reportedBy = $reportedData->actionTracker->FIRST_NAME.' '.$reportedData->actionTracker->LAST_NAME;
            $reportedDate = showDate($reportedData->CREATED_ON, config("constants.DATE_FORMAT"));
        }

        return [
            'ID' => $inspectiondetails->ID,
            'INSP_ID' => $inspectiondetails->ID,
            'INSPECTION_REFERENCE_NO' => $inspectiondetails->INSPECTION_REFERENCE_NO,
            'SITE_NAME' => $inspectiondetails->site->SITE_NAME,
            'STATUS' => $inspectiondetails->stage->STAGE_NAME,
            'STATUS_COLOR_CODE' => $inspectiondetails->stage->COLOR_CODE,
            'LOCATION_NAME' => $inspectiondetails->location->LOCATION_NAME,
            "TYPE_NAME"       => $inspectiondetails->type->INSP_TYPE_NAME,
            'INSP_DATE' =>  showDate($inspectiondetails->INSP_DATE, config("constants.DATE_FORMAT")),
            'DESCRIPTION' => $inspectiondetails->DESCRIPTION,
            'DRAFTED_DATE' => showDate($inspectiondetails->CREATED_ON, config("constants.DATE_FORMAT")),
            // 'DRAFTED_BY' => $inspectiondetails->draftedby->FIRST_NAME.' '.$inspectiondetails->draftedby->LAST_NAME,
            'DRAFTED_BY' => ($inspectiondetails->draftedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($inspectiondetails->draftedby->FIRST_NAME) . ' ' . $this->customDecrypt($inspectiondetails->draftedby->LAST_NAME)) : "-",
            'REPORTED_BY' => $reportedBy,
            'REPORTED_DATE' => $reportedDate,
        ];
    }

    public function transformInspectionDownloadableList($inspectionDownloadableData)
    {
        $inspectionFiles = $inspectionDownloadableData->files;
        $vvsstageId = $inspectionDownloadableData->STAGE_ID;
        $vvsaction = null;
        $vvsInspectionFileArray = [];

        $vvsUploadPath = config('constants.INSP_FILE_UPLOAD_PATH');

        if (!empty($inspectionFiles)) {
            foreach ($inspectionFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsInspectionFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsurlArray = explode(".", $vvsImagePath);
                        $vvsurlLastElement = end($vvsurlArray);
                        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
                            $vvsInspectionFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                            $vvsInspectionFileArray[$key1]['INSPECTION_FILE'] = $vvsImagePath;
                            $vvsInspectionFileArray[$key1]['MEDIA_TYPE_NAME'] = 'image';
                            // $vvsInspectionFileArray[$key1]['IS_DELETE'] = $vvsstageId == 1 && $vvsaction !== 'view';
                        } else{
                            $vvsInspectionFileArray[$key1]['MEDIA_TYPE_NAME'] = 'not a image';
                        }
                    }
                }
            }
        }

        $draftedDate = "";
        $drafterName = "";
        $reportedDate = "";
        $reporterName = "";

        if ($inspectionDownloadableData->relationLoaded('actionDraftedHistory')
                 && $inspectionDownloadableData->actionDraftedHistory) {
        $firstDraftedHistory = $inspectionDownloadableData->actionDraftedHistory->first();
            if ($firstDraftedHistory) {
                $draftedDate = showDate($firstDraftedHistory->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                $actionTracker = $firstDraftedHistory->actionTracker;
                if ($actionTracker) {
                    $drafterName = ($actionTracker->IS_INFO_REDUCTED == 0) ?
                     ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' .
                      $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    // $drafterName = $actionTracker->FIRST_NAME . ' ' . $actionTracker->LAST_NAME;
                }
            }
        }

        if ($inspectionDownloadableData->relationLoaded('actionReportedHistory')
                 && $inspectionDownloadableData->actionReportedHistory) {
        $firstReportedHistory = $inspectionDownloadableData->actionReportedHistory->first();
            if ($firstReportedHistory) {
                $reportedDate = showDate($firstReportedHistory->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                $actionTracker = $firstReportedHistory->actionTracker;
                if ($actionTracker) {
                    $reporterName = ($actionTracker->IS_INFO_REDUCTED == 0) ?
                     ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' .
                      $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    // $reporterName = $actionTracker->FIRST_NAME . ' ' . $actionTracker->LAST_NAME;
                }
            }
        }

        $recipents = [];
        if ($inspectionDownloadableData->relationLoaded('mapRecipent') &&
                    $inspectionDownloadableData->mapRecipent->count() > 0) {
            $mapRecipents = $inspectionDownloadableData->mapRecipent()->where('IS_DELETED', 0)
                            ->where('IS_ACTIVE', 1)->get();
            if ($mapRecipents) {
                foreach ($mapRecipents as $mapRecipent) {
                    $recipient = $mapRecipent->recipent;
                    if ($recipient) {
                        $recipientName = ($recipient->IS_INFO_REDUCTED == 0) ?
                             ($this->customDecrypt($recipient->FIRST_NAME) . ' ' .
                              $this->customDecrypt($recipient->LAST_NAME)) : "-";
                        $recipents[] = $recipientName;
                    }
                }
            }
        }
        

        return [
            "INSPECTION_ID"             => $inspectionDownloadableData->ID,
            "INSPECTION_REFERENCE_NO"   => $inspectionDownloadableData->INSPECTION_REFERENCE_NO,
            "TYPE_NAME"                 => $inspectionDownloadableData->type->INSP_TYPE_NAME,
            "LOCATION_NAME"             => $inspectionDownloadableData->location ? $inspectionDownloadableData->location->LOCATION_NAME : "",
            "INSP_DATE"                 => showDate($inspectionDownloadableData->INSP_DATE, config("constants.EXCEL_DATE_FORMAT")),
            "DESCRIPTION"               => $inspectionDownloadableData->DESCRIPTION,
            "STAGE_NAME"                => $inspectionDownloadableData->stage->STAGE_NAME,
            "RECIPENT"                  => implode(', ', $recipents),
            // Additional data from action history
            "DARFTED_DATE"              => $draftedDate,
            "DARFTED_BY"                => $drafterName,
            "REPORTED_DATE"             => $reportedDate,
            "REPORTED_BY"               => $reporterName,
            // Include file details
            "FILES"                     => $vvsInspectionFileArray,
        ];
    }

    
}