<?php

namespace App\Http\Resources\INSPECTION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\INSPECTION\InspectionCheckListOptionResource;

class InspectionMapCheckListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {        
        return [            
            'CHECKLIST_ID'      => $this->CHECKLIST_ID,
            'CHECKLIST_NAME'    => $this->MAP_CHECKLIST_NAME??$this->CHECKLIST_NAME,
            'TYPE_ID'           => $this->TYPE_ID, 
            'OPTION_ID'         => $this->OPTION_ID,
            'REMARKS'           => $this->REMARKS,
            'OPTIONS'           => InspectionCheckListOptionResource::collection($this->options)??[],
        ];
    }

    public static function transformChecklistItem($vvsInspectionChkGen)
    {
        return [
            'CHECKLIST_ID'      => $vvsInspectionChkGen->CHECKLIST_ID,
            'CHECKLIST_NAME'    => $vvsInspectionChkGen->MAP_CHECKLIST_NAME??$vvsInspectionChkGen->CHECKLIST_NAME,
            'TYPE_ID'           => $vvsInspectionChkGen->TYPE_ID,
            'OPTION_ID'         => $vvsInspectionChkGen->OPTION_ID,
            'OPTION_NAME'         => $vvsInspectionChkGen->OPTION_NAME,
            'REMARKS'           => $vvsInspectionChkGen->REMARKS,
            // 'OPTIONS'           => InspectionCheckListOptionResource::collection($this->options)??[],
        ];
    }
    


}
