<?php

namespace App\Http\Resources\INSPECTION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\INSPECTION\InspectionCheckListOptionResource;

class InspectionCheckListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'CHECKLIST_ID'      => $this->CHECKLIST_ID,
            'CHECKLIST_NAME'    => $this->CHECKLIST_NAME,
            'TYPE_ID'           => $this->TYPE_ID,            
            'OPTIONS'          => InspectionCheckListOptionResource::collection($this->options),
        ];
    }
}
