<?php

namespace App\Http\Resources\INSPECTION;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class InspectionActionHistoryResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'INSPECTION_ID' => $this->INSPECTION_ID,
            'ACTION' => $this->stage->STAGE_NAME,
            // 'ACTION_TAKEN_BY' => $this->actionTracker->FIRST_NAME.' '.$this->actionTracker->LAST_NAME,
            'ACTION_TAKEN_BY' => ($this->actionTracker->IS_INFO_REDUCTED == 0 ) ?
            ($this->customDecrypt($this->actionTracker->FIRST_NAME)." ".$this->customDecrypt($this->actionTracker->LAST_NAME))
            :"-",
            'COMMENTS' => $this->COMMENTS,
            'ACTION_TAKEN_ON' => ($this->CREATED_ON != "") ? showDate($this->CREATED_ON,"Y-m-d H:i:s") : "",

        ];
    }
}
