<?php

namespace App\Http\Resources\HIRA;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Traits\EncDecService;

class HiraResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "HIRA_ID"           => $this->ID,
            "HIRA_REFERENCE_NO" => $this->HIRA_REFERENCE_NO,
            "TITLE"             => $this->TITLE,
            "CURR_STATE"        => ($this->RENEWAL_COUNT == 0) ? (($this->STAGE_ID == 7) ? "Revised" :(($this->STAGE_ID == 9) ? "Renewed" : "Initial"))
                                    : ordinalConversion($this->RENEWAL_COUNT).(($this->parent->STAGE_ID == 9)? " Renewal" : " Approval"),
            "HIRA_START_DATE"   => showDate($this->HIRA_START_DATE, config("constants.DATE_FORMAT")),
            "HIRA_END_DATE"     => showDate($this->HIRA_END_DATE, config("constants.DATE_FORMAT")),
            "LOCATION_NAME"     => $this->location->LOCATION_NAME,
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS,
            "STAGE_NAME"        => $this->stage->STAGE_NAME,
            "STAGE_COLOR"       => $this->stage->COLOR_CODE,
            "IS_DELETE_BTN"     => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0)            
        ];
    }

    public static function transformHira($hiradetails)
    {
        $max_hira_date = date("Y-m-d H:i:s", strtotime('+1 days', strtotime($hiradetails->HIRA_END_DATE)));        
        return [
            'ID' => $hiradetails->ID,
            'HIRA_ID' => $hiradetails->ID,
            'HIRA_REFERENCE_NO' => $hiradetails->HIRA_REFERENCE_NO,
            'SITE_ID' =>$hiradetails->SITE_ID,
            'SITE'    =>$hiradetails->site->SITE_NAME,
            'LOCATION_ID' => $hiradetails->LOCATION_ID,
            'LOCATION' => $hiradetails->location->LOCATION_NAME,
            'TITLE' => $hiradetails->TITLE,
            'HIRA_START_DATE' =>  showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")),
            'HIRA_END_DATE' => showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")), 
            'REVISION' => $hiradetails->RENEWAL_COUNT,
            'STATUS' => $hiradetails->stage->STAGE_NAME,
            'TOP_PARENT_HIRA_ID' => $hiradetails->TOP_PARENT_HIRA_ID,
            'PARENT_HIRA_ID' => $hiradetails->PARENT_HIRA_ID, 
            'HIRA_RENEW_START_DATE' => showDate($max_hira_date, config("constants.DATE_FORMAT")),
            'HIRA_RENEW_END_DATE' => showDate($max_hira_date, config("constants.DATE_FORMAT")),            
            
            // 'RENEWAL_COUNT' => $hiradetails->RENEWAL_COUNT,
        ];
    }

    public function transformHiraReport($hiradetails)
    { 
        $approvedBy = "";
        $approvedDate = "";
        if(isset($hiradetails->approvedby) && in_array($hiradetails->STAGE_ID,[5,7])){
            $approvedData = $hiradetails->approvedby->first();
            $actionTracker = $approvedData->actionTracker;
            if ($actionTracker) {
            // $approvedBy = $approvedData->actionTracker->FIRST_NAME.' '.$approvedData->actionTracker->LAST_NAME;
            $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
            $approvedDate = showDate($approvedData->CREATED_ON, config("constants.DATE_FORMAT"));
        }
        $reviewedBy = "";
        if(isset($hiradetails->reviewedby) && in_array($hiradetails->STAGE_ID,[3,5,7])){
            $reviewdData = $hiradetails->reviewedby->first();
            $actionTracker = $reviewdData->actionTracker;
            if ($actionTracker) {
            // $reviewedBy = $reviewdData->actionTracker->FIRST_NAME.' '.$reviewdData->actionTracker->LAST_NAME;
            $reviewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        return [
            'ID' => $hiradetails->ID,
            'HIRA_ID' => $hiradetails->ID,
            'HIRA_REFERENCE_NO' => $hiradetails->HIRA_REFERENCE_NO,
            'SITE_NAME' => $hiradetails->site->SITE_NAME,            
            'STATUS' => $hiradetails->stage->STAGE_NAME,
            'STATUS_COLOR_CODE' => $hiradetails->stage->COLOR_CODE,
            'TOP_PARENT_HIRA_ID' => $hiradetails->TOP_PARENT_HIRA_ID,
            'PARENT_HIRA_ID' => $hiradetails->PARENT_HIRA_ID,
            'RENEWAL_COUNT' => $hiradetails->RENEWAL_COUNT,
            'RENEWAL_VERSION' => (($hiradetails->RENEWAL_COUNT == 0)?"Initial": ordinalConversion($hiradetails->RENEWAL_COUNT)." Renewal"),
            'LOCATION_NAME' => $hiradetails->location->LOCATION_NAME,
            'HIRA_START_DATE' =>  showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")),
            'HIRA_END_DATE' => showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")), 
            'TITLE' => $hiradetails->TITLE,
            'VERSION_DATE' => showDate($hiradetails->CREATED_ON, config("constants.DATE_FORMAT")), 
            // 'PREPARED_BY' => $hiradetails->preparedby->FIRST_NAME.' '.$hiradetails->preparedby->LAST_NAME,
            'PREPARED_BY' => ($hiradetails->preparedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($hiradetails->preparedby->FIRST_NAME) . ' ' . $this->customDecrypt($hiradetails->preparedby->LAST_NAME)) : "-",
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REVIEWED_BY' => $reviewedBy,                         
        ];
    }

    public function transformHiraXlReport($hiradetails)
    { 
        $approvedBy = "";
        $approvedDate = "";
        if(isset($hiradetails->approvedby) && in_array($hiradetails->STAGE_ID,[5,7])){
            $approvedData = $hiradetails->approvedby->first();
            $actionTracker = $approvedData->actionTracker;
            if ($actionTracker) {
            // $approvedBy = $approvedData->actionTracker->FIRST_NAME.' '.$approvedData->actionTracker->LAST_NAME;
            $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
            $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
        }
        $reviewedBy = "";
        if(isset($hiradetails->reviewedby) && in_array($hiradetails->STAGE_ID,[3,5,7])){
            $reviewdData = $hiradetails->reviewedby->first();
            $actionTracker = $reviewdData->actionTracker;
            if ($actionTracker) {
            // $reviewedBy = $reviewdData->actionTracker->FIRST_NAME.' '.$reviewdData->actionTracker->LAST_NAME;
            $reviewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        return [
            'ID' => $hiradetails->ID,
            'HIRA_ID' => $hiradetails->ID,
            'HIRA_REFERENCE_NO' => $hiradetails->HIRA_REFERENCE_NO,
            'SITE_NAME' => $hiradetails->site->SITE_NAME,            
            'STATUS' => $hiradetails->stage->STAGE_NAME,
            'STATUS_COLOR_CODE' => $hiradetails->stage->COLOR_CODE,
            'TOP_PARENT_HIRA_ID' => $hiradetails->TOP_PARENT_HIRA_ID,
            'PARENT_HIRA_ID' => $hiradetails->PARENT_HIRA_ID,
            'RENEWAL_COUNT' => $hiradetails->RENEWAL_COUNT,
            'RENEWAL_VERSION' => (($hiradetails->RENEWAL_COUNT == 0)?"Initial": $hiradetails->RENEWAL_COUNT),
            'LOCATION_NAME' => $hiradetails->location->LOCATION_NAME,
            'HIRA_START_DATE' =>  showDate($hiradetails->HIRA_START_DATE, config("constants.EXCEL_DATE_FORMAT")),
            'HIRA_END_DATE' => showDate($hiradetails->HIRA_END_DATE, config("constants.EXCEL_DATE_FORMAT")), 
            'TITLE' => $hiradetails->TITLE,
            'VERSION_DATE' => showDate($hiradetails->CREATED_ON, config("constants.EXCEL_DATE_FORMAT")), 
            // 'PREPARED_BY' => $hiradetails->preparedby->FIRST_NAME.' '.$hiradetails->preparedby->LAST_NAME,
            'PREPARED_BY' => ($hiradetails->preparedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($hiradetails->preparedby->FIRST_NAME) . ' ' . $this->customDecrypt($hiradetails->preparedby->LAST_NAME)) : "-",
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REVIEWED_BY' => $reviewedBy,                         
        ];
    }

    public function transformHiraRevisionReport($hiradetails)
    { 
        $approvedBy = "";
        $approvedDate = "";
        if(isset($hiradetails->approvedby) && in_array($hiradetails->STAGE_ID,[5,7])){
            $approvedData = $hiradetails->approvedby->first();
            $actionTracker = $approvedData->actionTracker;
            if ($actionTracker) {
            // $approvedBy = $approvedData->actionTracker->FIRST_NAME.' '.$approvedData->actionTracker->LAST_NAME;
            $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
            $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
        }
        $reviewedBy = "";
        if(isset($hiradetails->reviewedby) && in_array($hiradetails->STAGE_ID,[3,5,7])){
            $reviewdData = $hiradetails->reviewedby->first();
            $actionTracker = $reviewdData->actionTracker;
            if ($actionTracker) {
            // $reviewedBy = $reviewdData->actionTracker->FIRST_NAME.' '.$reviewdData->actionTracker->LAST_NAME;
            $reviewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
            }
        }
        return [               
            'STATUS' => $hiradetails->stage->STAGE_NAME, 
            'STATUS_COLOR_CODE' => $hiradetails->stage->COLOR_CODE,           
            'RENEWAL_COUNT' => $hiradetails->RENEWAL_COUNT,
            'RENEWAL_VERSION' => (($hiradetails->RENEWAL_COUNT == 0)?"Initial": $hiradetails->RENEWAL_COUNT),
            'LOCATION_NAME' => $hiradetails->location->LOCATION_NAME,
            'HIRA_START_DATE' =>  showDate($hiradetails->HIRA_START_DATE, config("constants.EXCEL_DATE_FORMAT")),
            'HIRA_END_DATE' => showDate($hiradetails->HIRA_END_DATE, config("constants.EXCEL_DATE_FORMAT")),
            'TITLE' => $hiradetails->TITLE,
            'VERSION_DATE' => showDate($hiradetails->CREATED_ON, config("constants.EXCEL_DATE_FORMAT")),
            // 'PREPARED_BY' => $hiradetails->preparedby->FIRST_NAME.' '.$hiradetails->preparedby->LAST_NAME,
            'PREPARED_BY' => ($hiradetails->preparedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($hiradetails->preparedby->FIRST_NAME) . ' ' . $this->customDecrypt($hiradetails->preparedby->LAST_NAME)) : "-",
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REVIEWED_BY' => $reviewedBy,                         
        ];
    }

    public function transformHiraListReport($hiradetails)
    {
        $approvedBy = "";
        $approvedDate = "";
        if(isset($hiradetails->approvedby)){
            $approvedData = $hiradetails->approvedby->first();
            if ($approvedData) {
                if(isset($approvedData->actionTracker)){
                    $actionTracker = $approvedData->actionTracker;
                    if ($actionTracker) {
                    $approvedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                }
                if (isset($approvedData->CREATED_ON)) {
                    $approvedDate = showDate($approvedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $reviewedBy = "";
        $reviewedDate = "";
        if(isset($hiradetails->reviewedby)){
            $reviewdData = $hiradetails->reviewedby->first();
            if ($reviewdData) {
                if (isset($reviewdData->actionTracker)) {
                    $actionTracker = $reviewdData->actionTracker;
                    if ($actionTracker) {
                    $reviewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $reviewedBy = $reviewdData->actionTracker->FIRST_NAME . ' ' . $reviewdData->actionTracker->LAST_NAME;
                }
                if (isset($reviewdData->CREATED_ON)) {
                    $reviewedDate = showDate($reviewdData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $sendBackedBy = "";
        $sendBackedDate = "";
        if(isset($hiradetails->sendbackedby)){
            $sendBackedData = $hiradetails->sendbackedby->first();
            if ($sendBackedData) {
                if (isset($sendBackedData->actionTracker)) {
                    $actionTracker = $sendBackedData->actionTracker;
                    if ($actionTracker) {
                    $sendBackedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $sendBackedBy = $sendBackedData->actionTracker->FIRST_NAME . ' ' . $sendBackedData->actionTracker->LAST_NAME;
                }
                if (isset($sendBackedData->CREATED_ON)) {
                    $sendBackedDate = showDate($sendBackedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $revisedBy = "";
        $revisedDate = "";
        if(isset($hiradetails->revisedby)){
            $revisedData = $hiradetails->revisedby->first();
            if ($revisedData) {
                if (isset($revisedData->actionTracker)) {
                    $actionTracker = $revisedData->actionTracker;
                    if ($actionTracker) {
                    $revisedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $revisedBy = $revisedData->actionTracker->FIRST_NAME . ' ' . $revisedData->actionTracker->LAST_NAME;
                }
                if (isset($revisedData->CREATED_ON)) {
                    $revisedDate = showDate($revisedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        $renewedBy = "";
        $renewedDate = "";
        if(isset($hiradetails->renewedby)){
            $renewedData = $hiradetails->renewedby->first();
            if ($renewedData) {
                if (isset($renewedData->actionTracker)) {
                    $actionTracker = $renewedData->actionTracker;
                    if ($actionTracker) {
                    $renewedBy = ($actionTracker->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' . $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                    // $renewedBy = $renewedData->actionTracker->FIRST_NAME . ' ' . $renewedData->actionTracker->LAST_NAME;
                }
                if (isset($renewedData->CREATED_ON)) {
                    $renewedDate = showDate($renewedData->CREATED_ON, config("constants.EXCEL_DATE_FORMAT"));
                }
            }
        }
        return [
            'ID' => $hiradetails->ID,
            'HIRA_ID' => $hiradetails->ID,
            'HIRA_REFERENCE_NO' => $hiradetails->HIRA_REFERENCE_NO,
            'SITE_NAME' => $hiradetails->site->SITE_NAME,
            'STATUS' => $hiradetails->stage->STAGE_NAME,
            'STATUS_COLOR_CODE' => $hiradetails->stage->COLOR_CODE,
            'TOP_PARENT_HIRA_ID' => $hiradetails->TOP_PARENT_HIRA_ID,
            'PARENT_HIRA_ID' => $hiradetails->PARENT_HIRA_ID,
            'RENEWAL_COUNT' => $hiradetails->RENEWAL_COUNT,
            'RENEWAL_VERSION' => (($hiradetails->RENEWAL_COUNT == 0)?"Initial": ordinalConversion($hiradetails->RENEWAL_COUNT)." Renewal"),
            'LOCATION_NAME' => $hiradetails->location->LOCATION_NAME,
            'HIRA_START_DATE' =>  showDate($hiradetails->HIRA_START_DATE, config("constants.EXCEL_DATE_FORMAT")),
            'HIRA_END_DATE' => showDate($hiradetails->HIRA_END_DATE, config("constants.EXCEL_DATE_FORMAT")),
            'TITLE' => $hiradetails->TITLE,
            'VERSION_DATE' => showDate($hiradetails->CREATED_ON, config("constants.EXCEL_DATE_FORMAT")),
            // 'PREPARED_BY' => $hiradetails->preparedby->FIRST_NAME.' '.$hiradetails->preparedby->LAST_NAME,
            'PREPARED_BY' => ($hiradetails->preparedby->IS_INFO_REDUCTED == 0) ? ($this->customDecrypt($hiradetails->preparedby->FIRST_NAME) . ' ' . $this->customDecrypt($hiradetails->preparedby->LAST_NAME)) : "-",
            'PREPARED_DATE' => showDate($hiradetails->CREATED_ON, config("constants.EXCEL_DATE_FORMAT")),
            'APPROVED_BY' => $approvedBy,
            'APPROVED_DATE' => $approvedDate,
            'REVIEWED_BY' => $reviewedBy,
            'REVIEWED_DATE' => $reviewedDate,
            'SEND_BACKED_BY' => $sendBackedBy,
            'SEND_BACKED_DATE' => $sendBackedDate,
            'REVISED_BY' => $revisedBy,
            'REVISED_DATE' => $revisedDate,
            'RENEWED_BY' => $renewedBy,
            'RENEWED_DATE' => $renewedDate,
        ];
    }
}