<?php

namespace App\Http\Resources\HIRA;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\HIRA\HiraMstDeclarationResource;
use App\Services\HIRA\HiraMstDeclarationServices;
use App\Http\Traits\EncDecService;

class HiraActivityResource extends JsonResource
{
    use EncDecService;
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $vvsHiraDeclService = new HiraMstDeclarationServices();
        $declarationACM = $vvsHiraDeclService->getHiraACMlList();
        $declarationData = HiraMstDeclarationResource::collection($declarationACM);
        return [
            "ID"                        => $this->ID,
            "HIRA_ID"                   => $this->HIRA_ID,
            "JOB_ID"                    => $this->JOB_ID,
            "JOB_NAME"                  => $this->job->JOB_NAME,
            "ACTIVITY_ID"               => $this->activitytype->pluck("MST_ACTIVITY_TYPE_ID"),            
            "RISK_RELATED_ID"           => $this->RISK_RELATED_ID,
            "RISK_RELATED_NAME"         => $this->riskrelated->RISK_RELATED_NAME,
            "DESCRIPTION"               => $this->DESCRIPTION,
            "IS_PTW_REQUIRED"           => $this->IS_PTW_REQUIRED,
            "PTW_TYPE_ID"               => $this->PTW_TYPE_ID,
            "PTW_TYPE"                  => (($this->PTW_TYPE_ID)?$this->ptwtype->TYPE_NAME:""),
            "SEVERITY_ID"               => $this->SEVERITY_ID,
            "SEVERITY_NAME"             => $this->severity->SEVERITY_NAME,
            "LIKELIHOOD_ID"             => $this->LIKELIHOOD_ID,
            "LIKELIHOOD_NAME"           => $this->likelihood->LIKELIHOOD_NAME,
            "RISK_FACTOR"               => $this->severity->SEVERITY_NAME.$this->likelihood->LIKELIHOOD_NAME,
            "RISK_FACTOR_COLOUR"        => getSeverityLikehoodColor($this->severity->SEVERITY_NAME,$this->likelihood->LIKELIHOOD_NAME),
            "RISK_FACTOR_STAGE"         => getSeverityLikehoodStage($this->severity->SEVERITY_NAME,$this->likelihood->LIKELIHOOD_NAME),
            "ADDTNL_CONTROL_MEASURE"    => $this->ADDTNL_CONTROL_MEASURE,
            "ACTION_OWNER_ID"           => $this->ACTION_OWNER_ID,
            // "ACTION_OWNER_NAME"          => $this->actionOwner->FIRST_NAME.' '.$this->actionOwner->LAST_NAME,
            "ACTION_OWNER_NAME"          => ($this->actionOwner->IS_INFO_REDUCTED == 0 ) ?
                                    ($this->customDecrypt($this->actionOwner->FIRST_NAME).' '.$this->customDecrypt($this->actionOwner->LAST_NAME)):"-",
            "ACM_REMARKS"               => $this->ACM_REMARKS,
            "IS_ACCESS_CONTROL_BTN"     => (($this->ACTION_OWNER_ID == $request->CREATED_BY && $this->hira->STAGE_ID == 5 && $this->STAGE_ID == 1)? true : false),
            "ACM_DECLARATION"           => (($this->ACTION_OWNER_ID == $request->CREATED_BY && $this->hira->STAGE_ID == 5 && $this->STAGE_ID == 1)? $declarationData : []),
            "CONTROL_IN_PLACE"          => $this->controlinplaces->map(function ($item) {
                return ["CONTROL_IN_PLACE_NAME" => $item->CONTROL_IN_PLACE_NAME];
            }),
            "REF_DOC"                   => $this->refdocs->map(function ($item) {
                return ["REF_DOC_NAME" => $item->HIRA_MAP_REF_DOC_NAME];
            }),
            "ACTIVITY_NAME"         => $this->activitytype->map(function ($item) {
                return  $item->activity->ACTIVITY_NAME;
            })->implode(", "),            
            "CONTROL_IN_PLACE_LIST"     => $this->controlinplaces->pluck("CONTROL_IN_PLACE_NAME"),
            "REF_DOC_LIST"              => $this->refdocs->pluck("HIRA_MAP_REF_DOC_NAME"),
            "STAGE_ID"                  => $this->STAGE_ID,
            "STAGE_TEXT"                => (($this->STAGE_ID == 2)?"Accept control measures approved by action owner":"Accept control measures pending for action owner"),
            "IS_ACTIVE"                 => $this->IS_ACTIVE,
            "IS_DELETED"                => $this->IS_DELETED, 
            "ORD_BY_SEVERITY"           => $this->ORD_BY_SEVERITY,     
        ];
    }

    public static function transformHiraActivityListReport($vvsHiraActivities)
    {
        // prd($vvsHiraActivities);
        // $vvsHiraDeclService = new HiraMstDeclarationServices();
        // $declarationACM = $vvsHiraDeclService->getHiraACMlList();
        // $declarationData = HiraMstDeclarationResource::collection($declarationACM);
        return [
            "ID"                        => $vvsHiraActivities->ID ? $vvsHiraActivities->ID : "",
            "HIRA_ID"                   => $vvsHiraActivities->HIRA_ID,
            "JOB_ID"                    => $vvsHiraActivities->JOB_ID,
            "JOB_NAME"                  => $vvsHiraActivities->job->JOB_NAME,
            "ACTIVITY_ID"               => $vvsHiraActivities->activitytype->pluck("MST_ACTIVITY_TYPE_ID"),            
            "RISK_RELATED_ID"           => $vvsHiraActivities->RISK_RELATED_ID,
            "RISK_RELATED_NAME"         => $vvsHiraActivities->riskrelated->RISK_RELATED_NAME,
            "DESCRIPTION"               => $vvsHiraActivities->DESCRIPTION,
            "IS_PTW_REQUIRED"           => $vvsHiraActivities->IS_PTW_REQUIRED,
            "PTW_TYPE_ID"               => $vvsHiraActivities->PTW_TYPE_ID,
            "PTW_TYPE"                  => (($vvsHiraActivities->PTW_TYPE_ID)?$vvsHiraActivities->ptwtype->TYPE_NAME:""),
            "SEVERITY_ID"               => $vvsHiraActivities->SEVERITY_ID,
            "SEVERITY_NAME"             => $vvsHiraActivities->severity->SEVERITY_NAME,
            "LIKELIHOOD_ID"             => $vvsHiraActivities->LIKELIHOOD_ID,
            "LIKELIHOOD_NAME"           => $vvsHiraActivities->likelihood->LIKELIHOOD_NAME,
            "RISK_FACTOR"               => $vvsHiraActivities->severity->SEVERITY_NAME.$vvsHiraActivities->likelihood->LIKELIHOOD_NAME,
            "RISK_FACTOR_COLOUR"        => getSeverityLikehoodColor($vvsHiraActivities->severity->SEVERITY_NAME,$vvsHiraActivities->likelihood->LIKELIHOOD_NAME),
            "RISK_FACTOR_STAGE"         => getSeverityLikehoodStage($vvsHiraActivities->severity->SEVERITY_NAME,$vvsHiraActivities->likelihood->LIKELIHOOD_NAME),
            "ADDTNL_CONTROL_MEASURE"    => $vvsHiraActivities->ADDTNL_CONTROL_MEASURE,
            "ACTION_OWNER_ID"           => $vvsHiraActivities->ACTION_OWNER_ID,
            // "ACM_REMARKS"               => $vvsHiraActivities->ACM_REMARKS,
            // "IS_ACCESS_CONTROL_BTN"     => (($vvsHiraActivities->ACTION_OWNER_ID == $request->CREATED_BY && $vvsHiraActivities->hira->STAGE_ID == 5 && $vvsHiraActivities->STAGE_ID == 1)? true : false),
            // "ACM_DECLARATION"           => (($vvsHiraActivities->ACTION_OWNER_ID == $request->CREATED_BY && $vvsHiraActivities->hira->STAGE_ID == 5 && $vvsHiraActivities->STAGE_ID == 1)? $declarationData : []),
            // "CONTROL_IN_PLACE"          => $vvsHiraActivities->controlinplaces->map(function ($item) {
            //     return ["CONTROL_IN_PLACE_NAME" => $item->CONTROL_IN_PLACE_NAME];
            // }),
            // "REF_DOC"                   => $vvsHiraActivities->refdocs->map(function ($item) {
            //     return ["REF_DOC_NAME" => $item->HIRA_MAP_REF_DOC_NAME];
            // }),
            // "ACTIVITY_NAME"         => $vvsHiraActivities->activitytype->map(function ($item) {
            //     return  $item->activity->ACTIVITY_NAME;
            // })->implode(", "),            
            // "CONTROL_IN_PLACE_LIST"     => $vvsHiraActivities->controlinplaces->pluck("CONTROL_IN_PLACE_NAME"),
            // "REF_DOC_LIST"              => $vvsHiraActivities->refdocs->pluck("HIRA_MAP_REF_DOC_NAME"),
            // "STAGE_ID"                  => $vvsHiraActivities->STAGE_ID,
            // "STAGE_TEXT"                => (($vvsHiraActivities->STAGE_ID == 2)?"Accept control measures approved by action owner":"Accept control measures pending for action owner"),     
        ];
    }
}