<?php

namespace App\Http\Resources\Dashboard;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DashboardInspectionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */

    public static function transformPtwByLocation($inspCount, $locations)
    {
        $key = '';
        
        if (!empty($locations->LOCATION_NAME)) {
            $key .= $locations->LOCATION_NAME;
        }
        
        if (!empty($locations->BUILDING)) {
            $key .= ' | ' . $locations->BUILDING;
        }
        
        if (!empty($locations->FLOOR)) {
            $key .= ' | ' . $locations->FLOOR;
        }

        if (!empty($locations->WING)) {
            $key .= ' | ' . $locations->WING;
        }

        if (!empty($locations->DEPARTMENT)) {
            $key .= ' | ' . $locations->DEPARTMENT;
        }

        if (!empty($locations->CHECKLIST)) {
            $key .= ' | ' . $locations->CHECKLIST;
        }

        if (!empty($locations->QR_CODE)) {
            $key .= ' | ' . $locations->QR_CODE;
        }
        return [
            'KEY' => $key,
            'VALUE' => $inpCount,
        ];
    }
}