<?php

namespace App\Http\Requests\TRAINING;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class ListRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    //code
    protected function mandatoryFields($requestData)
    {
        $fields = ['SITE_ID'];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank.";
            }
        }
    }

    protected function checkNumericFields($requestData)
    {
        $numericFields = [ "SITE_ID"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value.";
            }
        }
    }


    public function listAPIInputValidation($requestData){
        $error = "";
        //filter the object element
        $requestData = objectFilter($requestData);

        $mandatoryError = $this->mandatoryFields($requestData);
        if ($mandatoryError) {
            $error = $mandatoryError;
        }

        $numericError = $this->checkNumericFields($requestData);
        if ($numericError) {
            $error =  $numericError;
        }
       
        return $error ;
    }
}