<?php

namespace App\Http\Requests\TRAINING;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\Training;
use App\Models\TrainingMstDeclaration;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class AddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {

        $fields = ["SITE_ID","TYPE_ID","LOCATION_ID","TOPIC_NAME","TRAINERS",
                    "TR_START_DATE", "TR_END_DATE"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID","TYPE_ID","LOCATION_ID"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    private function validateDateTimeFormat($datetime)
    {
        return strtotime($datetime) !== false;
    }

    protected function validatTrainingStartDateAndEndDate($requestedData)
    {
        $error = "";
        if (
            !$this->validateDateTimeFormat($requestedData->TR_START_DATE)  ||
            !$this->validateDateTimeFormat($requestedData->TR_END_DATE)
        ) {
            $error = "Training Start Date / Training End Date must be a valid date.";
        }
        if (strtotime($requestedData->TR_START_DATE) > strtotime($requestedData->TR_END_DATE)) {
            $error = "Training End Date must be bigger than Training Start Date.";
        }
       
        return $error;
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'TRAINERS' => 50,
            'REMARKS' => 450,
            'TOPIC_NAME'=>400
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
            }
        }
        return $error;
    }

    public function trainingAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);

        if($requestedData->ID != 0){
            $trainingData = Training::find($requestedData->ID); 
            $requestedData->TYPE_ID = $requestedData->TYPE_ID??$trainingData->TYPE_ID;          
            $requestedData->LOCATION_ID = $requestedData->LOCATION_ID??$trainingData->LOCATION_ID;
            $requestedData->TOPIC_NAME = $requestedData->TOPIC_NAME??$trainingData->TOPIC_NAME;
            $requestedData->TOPIC_ID = $requestedData->TOPIC_ID??$trainingData->TOPIC_ID;
            $requestedData->TRAINERS = $requestedData->TRAINERS??$trainingData->TRAINERS;
        }
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);

        if ($error) {
            return $error;
        }

        //Training start date and end date validation
        $error = $this->validatTrainingStartDateAndEndDate($requestedData);
        if ($error) {
            return $error;
        }

        if (in_array($action, ["SAVE"])) {
            $error = $this->validateParticipant($requestedData);
            if ($error) {
                return $error;
            }
       }

        if (in_array($action, ["SAVE"])) {
             //declaration validation
            if (isset($requestedData->DECLARATION_ID)  && count( $requestedData->DECLARATION_ID )) {
                $error = $this->validateDeclaration($requestedData->DECLARATION_ID, 1);
            }
            if ($error) {
                return $error;
            }
        }
        return $error;
    }

    protected function validateParticipant($requestedData)
    {
        $error = "";
        if ((!isset($requestedData->PARTICIPANT) || count( @$requestedData->PARTICIPANT ) == 0)
                && $requestedData->ACTION == 'SAVE') {
            $error = "Particpant Details is required.";
        } elseif (isset($requestedData->PARTICIPANT) && !is_array($requestedData->PARTICIPANT)) {
            $error = "Particpant Details is not valid.";
        } elseif(count($requestedData->PARTICIPANT) > 0) {
            foreach ($requestedData->PARTICIPANT as $key => $value) {
                $name = $value->NAME;
                $designation = $value->DESIGNATION;
                $organization = $value->ORGANIZATION;
                $score = $value->SCORE;
                
                $participantData = [$name, $designation, $organization, $score];
                $participantData  = array_filter($participantData);
                $participanFieldCount = 4;
                if (count($participantData) < $participanFieldCount) {
                    $error.= "Please fill all fields</br>";
                }

                $stringFieldsWithSize = [
                    'NAME' => 50,
                    'DESIGNATION' => 50,
                    'ORGANIZATION' => 50
                ];
                foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
                    if (
                        isset($value->$stringKey) &&
                        (!is_string($value->$stringKey) || strlen($value->$stringKey) > $stringValue)
                    ) {
                        $error.= str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
                    }
                }
                if (isset($value->SCORE) && !is_numeric($value->SCORE)) {
                    $error.= "Participant score must be a number  </br>";
                }
                if (isset($value->SCORE) && ($value->SCORE > 100)) {
                    $error.= "Invalid Particpant score </br>";
                }
            }
        }
        return $error;
    }
    public function getDeclarationSectionbyAction($action){
        $declarationSection = 0;
        if ($action == "DRAFT" || $action == "SAVE"){
            $declarationSection = 1;
        }
        elseif ($action == "MOVE_FORWARD"){
            $declarationSection = 2;
        }
        elseif ($action == "APPROVE"){
            $declarationSection = 3;
        }
        elseif ($action == "REJECT"){
            $declarationSection = 4;
        }
        
        return $declarationSection;
    }
    protected function validateDeclaration($declarationIds, $trAddPage)
    {
        $error = "";

        if (isset($declarationIds) && is_array($declarationIds)) {
            if (isset($trAddPage) && $trAddPage == 1) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
                    
            } elseif (isset($trAddPage) && $trAddPage == 2) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_MOVE_FORWARD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($trAddPage) && $trAddPage == 3) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_APPROVE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($trAddPage) && $trAddPage == 4) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_REJECT")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($trAddPage) && $trAddPage == 5) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_REQUEST_FOR_CLOSURE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($trAddPage) && $trAddPage == 6) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_CLOSE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($trAddPage) && $trAddPage == 7) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($trAddPage) && $trAddPage == 8) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_REQUEST_FOR_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            elseif (isset($trAddPage) && $trAddPage == 9) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_RENEW")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            elseif (isset($trAddPage) && $trAddPage == 10) {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "TR_ACCEPT_CONTROL_MEASURES")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            else {
                $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->whereNot("DECLARATION_GROUP", "TR_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereNotIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            $data = $allDeclarationData;
            if (count($data) != count($declarationIds)) {
                $error = "Some of the Declarations are not valid </br>";
            }
        } else {
            $error = "Please check all the Declarations.</br>";
        }
        return $error;
    }
    
}
