<?php

namespace App\Http\Requests\Report;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class ReportObservationListRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    //code
    protected function mandatoryFields($requestData)
    {
        $fields = ['SITE_ID'];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank.";
            }
        }
    }

    protected function checkNumericFields($requestData)
    {
        $numericFields = [ "SITE_ID" ,"OBS_TYPE_ID", "LOCATION_ID","STAGE_ID","PAGE_NUM","PAGE_SIZE"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value.";
            }
        }
    }


    public function listAPIInputValidation($requestData){
        $error = "";
        //filter the object element
        $requestData = objectFilter($requestData);

        $mandatoryError = $this->mandatoryFields($requestData);
        if ($mandatoryError) {
            $error = $mandatoryError;
        }

        $numericError = $this->checkNumericFields($requestData);
        if ($numericError) {
            $error =  $numericError;
        }

        if(!empty($requestData -> OBS_START_DATE) && !empty($requestData -> OBS_END_DATE)){
            if($requestData -> OBS_START_DATE == "" || $requestData -> OBS_END_DATE == ""){
                $error = "Inspection Duration is invalid.";
            }
            else {
                if( $requestData -> OBS_START_DATE > $requestData -> OBS_END_DATE ) {
                    $error = "Inspection Start Date should not be greater than Inspection End Date.";
                }              

            }
        }

        $pageSize = $requestData -> PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");
        if( $pageSize > config("constants.PAGINATION_PER_PAGE") ){
            $error =  config("constants.MAX_PAGE_SIZE") . config("constants.PAGINATION_PER_PAGE").".";
        }
        return $error ;
    }    
}