<?php

namespace App\Http\Requests\OBSERVATION;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\Observation;
use App\Models\ObservationMapDeclaration;
use App\Models\ObservationMstDeclaration;
use App\Models\User;
use App\Services\OBSERVATION\ObservationServices;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class AddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {

        $fields = ["SITE_ID", "OBS_TYPE_ID", "LOCATION_ID", "OBS_START_DATE","OBS_END_DATE"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID", "OBS_TYPE_ID", "LOCATION_ID","SEVERITY_ID","LIKELIHOOD_ID","ACTION_OWNER_ID"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    private function validateDateTimeFormat($datetime)
    {
        return strtotime($datetime) !== false;
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'DESCRIPTION' => 600,
            'RECOMMENDATION' => 600,
            'ACTION_TAKEN_DETAILS' => 600
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = "Please note that the". str_replace("_", " ", $stringKey) . " field is now limited to $stringValue characters for better readability";
            }
        }
        return $error;
    }   

    
    
    protected function validateDeclaration($declarationIds, $observationAddPage, $obs_id=0)
    {
        $error = "";

        if (isset($declarationIds) && is_array($declarationIds)) {
            if (isset($observationAddPage) && $observationAddPage == 1) {
                if($obs_id == 0){
                    $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP","LIKE",'%OBS_ADD%')->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
                }else{
                    $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", 'OBS_ADD')->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
                }
            } elseif (isset($observationAddPage) && $observationAddPage == 2) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_MOVE_FORWARD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($observationAddPage) && $observationAddPage == 3) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_ACCEPT_TIMELINE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($observationAddPage) && $observationAddPage == 4) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_REJECT")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($observationAddPage) && $observationAddPage == 5) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_REQUEST_FOR_CLOSURE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($observationAddPage) && $observationAddPage == 6) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_CLOSE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($observationAddPage) && $observationAddPage == 7) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($observationAddPage) && $observationAddPage == 8) {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_REQUEST_FOR_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            else {
                $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->whereNot("DECLARATION_GROUP", "OBS_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereNotIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            $data = $allDeclarationData;
            if (count($data) != count(array_unique($declarationIds))) {
                $error = "Some of the Declarations are not valid";
            }
        } else {
            $error = "Please check all the Declarations.";
        }
        return $error;
    }

    

    
    public function ObservationAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE","RENEW"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);

        if ($error) {
            return $error;
        }        

        //declaration validation
       
        if (isset($requestedData->DECLARATION_ID)  && count( $requestedData->DECLARATION_ID )) {
            $error = $this->validateDeclaration($requestedData->DECLARATION_ID, 1 ,$requestedData->ID);
        }
        if ($error) {
            return $error;
        }

        return $error;
    }

    public function validateCaptcha($requestedData){
        $ObservationId = $requestedData -> ID;
        $captchaCode = $requestedData -> CAPTCHA_CODE;
        $error = "";  
        if( !isset($captchaCode) || $captchaCode == "" ){
            $error = "Please provide Captcha Code.";
        }else{
            $ObservationCaptchaCheck = Observation::where("ID",$ObservationId)->where("CAPTCHA_CODE",$captchaCode)->first();
            if(empty($ObservationCaptchaCheck)){
                $error = "Captcha Code is not valid.";
            }
        }
        return $error;
       
    }

    public function getDeclarationSectionbyAction($action){
        $declarationSection = 0;
        if ($action == "DRAFT" ||$action == "SAVE"){
            $declarationSection = 1;
        }
        elseif ($action == "MOVE_FORWARD"){
            $declarationSection = 2;
        }
        elseif ($action == "APPROVE"){
            $declarationSection = 3;
        }
        elseif ($action == "REJECT"){
            $declarationSection = 4;
        }
        elseif ($action == "REQUEST_FOR_CLOSURE"){
            $declarationSection = 5;
        }
        elseif ($action == "CLOSE"){
            $declarationSection = 6;
        }
        elseif ($action == "SUSPEND"){
            $declarationSection = 7;
        }
        elseif ($action == "REQUEST_FOR_SUSPEND"){
            $declarationSection = 8;
        }
        elseif ($action == "REPORTER_APPROVE"){
            $declarationSection = 3;
        }
        elseif ($action == "REPORTER_REJECT"){
            $declarationSection = 4;
        }
        return $declarationSection;
    }
    public function ObservationSaveValidation()
    {
        $error = "";
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);

        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "";

        if (!in_array($action, ["MOVE_FORWARD","SEND_BACK","APPROVE","REJECT","REQUEST_FOR_CLOSURE","CLOSE","REPORTER_APPROVE","REPORTER_REJECT"])) {
            $error = "Please mention the type of activity in terms of ACTION.";
        }

        if (empty($requestedData->ID)) {
            $error = "Observation Id should not be blank.";
        }
        if (!is_numeric($requestedData->ID)) {
            $error = "Observation Id should is not a valid number.";
        }



        if ($error) {
            return $error;
        }

        $declarationSection = $this->getDeclarationSectionbyAction($action);
        
        //declaration validation
        if (isset($requestedData->DECLARATION_ID)) {
            $error = $this->validateDeclaration($requestedData->DECLARATION_ID, $declarationSection ,$requestedData->ID);
        }

        return $error;
    }   
    
}
