<?php

namespace App\Http\Requests\Master;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\PtwMstWorker;
use App\Models\PtwTypeMapWorkers;
use App\Models\PtwMstType;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class WorkmanAddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {
        $fields = ["SITE_ID", "WORKER_DESG_ID", "WORKER_CONTRACTOR_ID", "WORKER_NAME"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID", "WORKER_DESG_ID", "WORKER_CONTRACTOR_ID"];
        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    protected function validateTypeWorkers($typeIds)
    {
        $error = "";
        if (isset($typeIds) && is_array($typeIds)) {
            $allTypeData = PtwMstType::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                ->whereIn("TYPE_ID", $typeIds)->get();
            $data = $allTypeData->toArray();
            if (count($data) != count($typeIds)) {
                $error = "Some of Competency are not valid";
            }
        } else {
            $error = "Competency Data are not valid";
        }
        return $error;
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'WORKER_NAME' => 60
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
            }
        }
        return $error;
    }

    public function workerAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));        
        if($requestedData->WORKER_ID > 0){
            $vvsWorkerdDta = PtwMstWorker::where("IS_DELETED", 0)->where("WORKER_ID", $requestedData->WORKER_ID)->first();            
        }
        $requestedData->WORKER_NAME =  $requestedData->WORKER_NAME ??  $vvsWorkerdDta->WORKER_NAME;
        $requestedData->WORKER_DESG_ID =  $requestedData->WORKER_DESG_ID ??  $vvsWorkerdDta->WORKER_DESG_ID;
        $requestedData->WORKER_CONTRACTOR_ID =  $requestedData->WORKER_CONTRACTOR_ID ??  $vvsWorkerdDta->WORKER_CONTRACTOR_ID;
        $requestedData->WORKER_COMPETENCY =  $requestedData->WORKER_COMPETENCY ??  $vvsWorkerdDta->typeMappings->pluck('TYPE_ID')->toArray();     
        $requestedData = objectFilter($requestedData);
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "SAVE";
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);
        if ($error) {
            return $error;
        }
        //Competency field validation
        if (isset($requestedData->WORKER_COMPETENCY) && count($requestedData->WORKER_COMPETENCY)) {
            $error = $this->validateTypeWorkers($requestedData->WORKER_COMPETENCY);
        }
        return $error;
    }

    
    
}
