<?php

namespace App\Http\Requests\Master;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class SOPPolicyListRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function checkNumericFields($requestData)
    {
        $numericFields = [ "PAGE_NUM","PAGE_SIZE"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value.";
            }
        }
    }


    public function listAPIInputValidation($requestData){
        $error = "";
        //filter the object element
        $requestData = objectFilter($requestData);

        $numericError = $this->checkNumericFields($requestData);
        if ($numericError) {
            $error =  $numericError;
        }
        $pageSize = $requestData -> PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");
        if( $pageSize > config("constants.PAGINATION_PER_PAGE") ){
            $error =  config("constants.MAX_PAGE_SIZE") . config("constants.PAGINATION_PER_PAGE").".";
        }
        return $error ;
    }
    

}
