<?php

namespace App\Http\Requests\Master;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\MstRole;
use App\Models\User;
use App\Models\UserMapRole;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class MasterUserAccessAddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {
        $fields = ["EMAIL", "FIRST_NAME", "LAST_NAME"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["EMAIL"];
        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias)) {
                // Check if the field is email and validate it
                if ($numericAlias == "EMAIL") {
                    if (!filter_var($requestData->$numericAlias, FILTER_VALIDATE_EMAIL)) {
                        return "Input field $numericAlias is not valid.";
                    }
                } else {
                    // Check if the field is numeric
                    if (!is_numeric($requestData->$numericAlias)) {
                        return "Input field $numericAlias is expecting a numeric value.";
                    }
                }
            }
        }
    }

    protected function validateRoleDetails($roleDetails, $userId)
    {
        $error = "";
        if (isset($roleDetails) && is_array($roleDetails)) {
            foreach ($roleDetails as $role) {
                // Check if MODULE_NAME property exists and is not empty
                if (!isset($role->MODULE_NAME) || empty($role->MODULE_NAME)) {
                    $error = "MODULE_NAME is mandatory for each role detail.";
                    return $error;
                }
            }
            $roleIds = array_column($roleDetails, 'ROLE_ID');
            $validRoleIds = MstRole::where('IS_DELETED', 0)
                ->whereIn('ROLE_ID', $roleIds)
                ->pluck('ROLE_ID')
                ->toArray();
            
            if (count($validRoleIds) != count($roleIds)) {
                $invalidRoleIds = array_diff($roleIds, $validRoleIds);
                $error = "Some of the role ids are not valid: " . implode(', ', $invalidRoleIds);
            }
        } else {
            $error = "Role details are not valid.";
        }
        return $error;
    }

    protected function validateDBRoleDetails($roleDetails, $userId)
    {
        $error = "";
        if (isset($roleDetails) && is_array($roleDetails)) {
            foreach ($roleDetails as $role) {
                // Check if MODULE_NAME property exists and is not empty
                if (!isset($role['MODULE_NAME']) || empty($role['MODULE_NAME'])) {
                    $error = "MODULE_NAME is mandatory for each role detail.";
                    return $error;
                }
            }
            $roleIds = array_column($roleDetails, 'ROLE_ID');
            $validRoleIds = MstRole::where('IS_DELETED', 0)
                ->whereIn('ROLE_ID', $roleIds)
                ->pluck('ROLE_ID')
                ->toArray();
            
            if (count($validRoleIds) != count($roleIds)) {
                $invalidRoleIds = array_diff($roleIds, $validRoleIds);
                $error = "Some of the role ids are not valid: " . implode(', ', $invalidRoleIds);
            }
        } else {
            $error = "Role details are not valid.";
        }
        return $error;
    }


    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'EMAIL' => 100,
            'FIRST_NAME' => 100,
            'LAST_NAME' => 100,
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
            }
        }
        return $error;
    }

    public function userAccessAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $vvsWorkerdDta = null;
        $oldData = (object)[];

        if ($requestedData->USER_ID > 0) {
            $vvsWorkerdDta = User::where("IS_DELETED", 0)->where("ID", $requestedData->USER_ID)->first();

            foreach ($vvsWorkerdDta->roles as $role) {
                $oldData->ROLE_DTLS[] = [
                    'MODULE_NAME' => $role->MODULE_NAME,
                    'ROLE_ID' => $role->ROLE_ID
                ];
            }
        }

        // Populate missing fields with data from the database
        $requestedData->EMAIL = $requestedData->EMAIL ??
         ($vvsWorkerdDta ? $this->customDecrypt($vvsWorkerdDta->EMAIL) : null);
        $requestedData->FIRST_NAME = $requestedData->FIRST_NAME ?? ($vvsWorkerdDta ? $vvsWorkerdDta->FIRST_NAME : null);
        $requestedData->LAST_NAME = $requestedData->LAST_NAME ?? ($vvsWorkerdDta ? $vvsWorkerdDta->LAST_NAME : null);
        $roleDtls = $requestedData->ROLE_DTLS ?? ($oldData->ROLE_DTLS ?? null);

        $requestedData = objectFilter($requestedData);
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "SAVE";

        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);

        if ($error) {
            return $error;
        }

        // Validation
        if(!isset($requestedData->ROLE_DTLS) || empty($requestedData->ROLE_DTLS)){
            if (isset($roleDtls) && count($roleDtls)) {
                $error = $this->validateDBRoleDetails($roleDtls, $requestedData->USER_ID);
            }
        } else {
            if (isset($roleDtls) && count($roleDtls)) {
                $error = $this->validateRoleDetails($roleDtls, $requestedData->USER_ID);
            }
        }

        return $error;
    }

}
