<?php

namespace App\Http\Requests\Master;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\PtwMstContractor;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class ContractorAddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {
        $fields = ["SITE_ID", "CONTRACTOR_NAME"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID"];
        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'CONTRACTOR_NAME' => 50,
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
            }
        }
        return $error;
    }

    public function contractorAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $vvsWorkerdDta = "";
        
        if(isset($requestedData->CONTRACTOR_ID) && $requestedData->CONTRACTOR_ID > 0){
            $vvsWorkerdDta = PtwMstContractor::where("IS_DELETED", 0)->where("CONTRACTOR_ID", $requestedData->CONTRACTOR_ID)->first();            
        }
        $requestedData->SITE_ID =  $requestedData->SITE_ID ??  $vvsWorkerdDta->SITE_ID;
        $requestedData->CONTRACTOR_NAME =  $requestedData->CONTRACTOR_NAME ??  $vvsWorkerdDta->CONTRACTOR_NAME;
        $requestedData = objectFilter($requestedData);
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "SAVE";
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);
        if ($error) {
            return $error;
        }
        // $error = "";
        // //filter the object element
        // $requestData = objectFilter($requestData);

        // $numericError = $this->draftCheckNumericFields($requestData);
        // if ($numericError) {
        //     $error =  $numericError;
        // }

        // $fieldsWithSizeError = $this->checkStringFieldsWithSize($requestData);
        // if ($fieldsWithSizeError) {
        //     $error = $fieldsWithSizeError;
        // }

        // $mandatoryError = $this->draftMandatoryFields($requestData);
        // if ($mandatoryError) {
        //     $error = $mandatoryError;
        // }
        
        // return $error;
    }

    
    
}
