<?php

namespace App\Http\Requests\INSPECTION;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class ViewRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }
    


    public function editAPIInputValidation($requestData){
        $error = "";
        $inputField = ['INSP_ID'];
        $vvObjsKeyList1 = array_keys((array)$requestData);

        //required field validation
        foreach ($inputField as $key) {
            if (empty($requestData->$key)) {
                $error.= str_replace("_", " ", strtolower($key)) . " should not be blank.";
            }
        }

        //if other than PTW_ID or any pre defined parametes are set then validation violates
        foreach ($vvObjsKeyList1 as $vvskey) {
            if(!in_array($vvskey, $inputField)){
                $error.= "Invalid input. ".str_replace("_", " ", strtolower($vvskey)) . " should not be allowed.";
            }
        }
        

        //check numeric values
        foreach ($inputField as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                $error.= "input field $numericAlias is expecting a numeric value.";
            }
        }
        
        return $error ;
    }

}
