<?php

namespace App\Http\Requests\INSPECTION;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class MasterListRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }   

    
    public function masterAPIInputValidation($requestData){
        $error = "";
        $fields = ['SITE_ID'];
        $vvObjsKeyList1 = array_keys((array)$requestData);
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return ucwords(str_replace("_", " ", strtolower($key))). " should not be blank.";
            }
        }
        foreach ($vvObjsKeyList1 as $vvskey) {
            if(!in_array($vvskey, $fields)){
                return " Invalid input. ".ucwords(str_replace("_", " ", strtolower($vvskey))) . " should not be allowed.";
            }
        } 
        $numericFields = [ "SITE_ID"];
        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return " input field $numericAlias is expecting a numeric value.";
            }
        }
        
        return $error ;
    }

    public function checkListAPIInputValidation($requestData){
        $error = "";
        $fields = ['TYPE_ID'];
        $vvObjsKeyList1 = array_keys((array)$requestData);
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return ucwords(str_replace("_", " ", strtolower($key))) . " should not be blank.";
            }
        }
        foreach ($vvObjsKeyList1 as $vvskey) {
            if(!in_array($vvskey, $fields)){
                return " Invalid input. ".ucwords(str_replace("_", " ", strtolower($vvskey))) . " should not be allowed.";
            }
        }
        $numericFields = [ "TYPE_ID"];
        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return " Input field $numericAlias is expecting a numeric value.";
            }
        }
        
        return $error ;
    }

}
