<?php

namespace App\Http\Requests\INSPECTION;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\Inspection;
use App\Models\InspectionMapChecklist;
use App\Models\InspectionMapChecklistOption;
use App\Models\InspectionMapDeclaration;
use App\Models\InspectionMstDeclaration;
use App\Models\User;
use App\Models\InspectionMapRecipent;
use App\Services\INSPECTION\InspectionServices;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class AddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {

        $fields = ["SITE_ID", "TYPE_ID", "LOCATION_ID", "INSP_DATE"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID", "TYPE_ID", "LOCATION_ID"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    private function validateDateTimeFormat($datetime)
    {
        return strtotime($datetime) !== false;
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'DESCRIPTION' => 600
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = "Please note that the". str_replace("_", " ", $stringKey) . " field is now limited to $stringValue characters for better readability";
            }
        }
        return $error;
    }   

    protected function validateRecipent($recipentIds)
    {
        $error = "";

        if (isset($recipentIds) && is_array($recipentIds)) {
            $allRecipentData = User::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                ->whereIn("ID", $recipentIds)->get();
            $data = $allRecipentData->toArray();
            if (count($data) != count($recipentIds)) {
                $error = "Some of Recipents are not valid";
            }
        } else {
            $error = "Recipents Data are not valid";
        }
        return $error;
    }
    
    protected function validateDeclaration($declarationIds, $InspectionAddPage)
    {
        $error = "";

        if (isset($declarationIds) && is_array($declarationIds)) {
            if (isset($InspectionAddPage) && $InspectionAddPage == 1) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
                    
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 2) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_MOVE_FORWARD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 3) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_APPROVE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 4) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_REJECT")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 5) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_REQUEST_FOR_CLOSURE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 6) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_CLOSE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 7) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($InspectionAddPage) && $InspectionAddPage == 8) {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "INSP_REQUEST_FOR_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            else {
                $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->whereNot("DECLARATION_GROUP", "INSP_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereNotIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            $data = $allDeclarationData;
            if (count($data) != count($declarationIds)) {
                $error = "Some of the Declarations are not valid";
            }
        } else {
            $error = "Please check all the Declarations.";
        }
        return $error;
    }

    

    protected function validateChecklist($requestData){
        $error = "";
        if (isset($requestData->CHECKLIST) && is_array($requestData->CHECKLIST)) {
            if(count($requestData->CHECKLIST)){
                foreach($requestData->CHECKLIST as $key => $value){
                    if($value->OPTION_ID != 999 || $value->CHECKLIST_ID != 999){
                        $checklistOptionData = InspectionMapChecklistOption::where("CHECKLIST_ID",$value->CHECKLIST_ID)
                                                ->where("CHECKLIST_OPTION_ID",$value->OPTION_ID)
                                                ->where("IS_ACTIVE",1)
                                                ->where("IS_DELETED",0)->get();
                        if(count($checklistOptionData -> toArray()) == 0){
                            $error = "Checklist Data are not valid.";
                        }else{
                            $data = $checklistOptionData -> toArray();
                            if($data[0]["POSITIVITY"] == 0 && (!isset($value->REMARKS) || trim($value->REMARKS)=="")){
                                $error = "Upon thorough evaluation against safety checklist, it has been determined that your response does not meet the necessary criteria to proceed with the Permit to Work (Inspection) submission. Compliance with all checklist points is mandatory before raising a Inspection.";
                            }
                            //validation for checking night time checklist option
                        }
                    }
                    
                }
            }
        }else {
            $error = "Checklist Data are not valid";
        }
        return $error;
    }
    public function InspectionAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE","RENEW"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);

        if ($error) {
            return $error;
        } 

        //worker validation

        if (isset($requestedData->USER_ID) && count( $requestedData->USER_ID )) {
            $error = $this->validateRecipent($requestedData->USER_ID);
        }
        if ($error) {
            return $error;
        }

        //declaration validation
       
        if (isset($requestedData->DECLARATION_ID)  && count( $requestedData->DECLARATION_ID )) {
            $error = $this->validateDeclaration($requestedData->DECLARATION_ID, 1);
        }
        if ($error) {
            return $error;
        }
        
        
        if (isset($requestedData->CHECKLIST) || isset($requestedData->CHECKLIST)) {
            $error = $this->validateChecklist($requestedData);
        }
        if ($error) {
            return $error;
        }       

        if (in_array($action, ["SAVE"])) {
            if(!isset($requestedData->CHECKLIST)){
                $error = "Please provide all the required fields." ;
            }            
        }

        return $error;
    }

    public function validateCaptcha($requestedData){
        $InspectionId = $requestedData -> ID;
        $captchaCode = $requestedData -> CAPTCHA_CODE;
        $error = "";  
        if( !isset($captchaCode) || $captchaCode == "" ){
            $error = "Please provide Captcha Code.";
        }else{
            $InspectionCaptchaCheck = Inspection::where("ID",$InspectionId)->where("CAPTCHA_CODE",$captchaCode)->first();
            if(empty($InspectionCaptchaCheck)){
                $error = "Captcha Code is not valid.";
            }
        }
        return $error;
       
    }

    public function getDeclarationSectionbyAction($action){
        $declarationSection = 0;
        if ($action == "DRAFT" ||$action == "SAVE"){
            $declarationSection = 1;
        }
        elseif ($action == "MOVE_FORWARD"){
            $declarationSection = 2;
        }
        elseif ($action == "APPROVE"){
            $declarationSection = 3;
        }
        elseif ($action == "REJECT"){
            $declarationSection = 4;
        }
        elseif ($action == "REQUEST_FOR_CLOSURE"){
            $declarationSection = 5;
        }
        elseif ($action == "CLOSE"){
            $declarationSection = 6;
        }
        elseif ($action == "SUSPEND"){
            $declarationSection = 7;
        }
        elseif ($action == "REQUEST_FOR_SUSPEND"){
            $declarationSection = 8;
        }
        return $declarationSection;
    }
    public function InspectionSaveValidation()
    {
        $error = "";
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);

        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "";

        if (!in_array($action, ["MOVE_FORWARD","SEND_BACK","APPROVE","REJECT","REQUEST_FOR_CLOSURE","REQUEST_FOR_SUSPEND","CLOSE","SUSPEND"])) {
            $error = "Please mention the type of activity in terms of ACTION.";
        }

        if (empty($requestedData->ID)) {
            $error = "Inspection Id should not be blank.";
        }
        if (!is_numeric($requestedData->ID)) {
            $error = "Inspection Id should is not a valid number.";
        }



        if ($error) {
            return $error;
        }

        $declarationSection = $this->getDeclarationSectionbyAction($action);
        
        //declaration validation
        if (isset($requestedData->DECLARATION_ID)) {
            $error = $this->validateDeclaration($requestedData->DECLARATION_ID, $declarationSection);
        }

        if($requestedData -> ACTION == "CLOSE"){
            $error = $this -> validateCaptcha($requestedData);
            
        } 

        return $error;
    }


    public function inspectionCheckListData($inspectionId, $creator)
    {
        $vvsInspectionChkListData = [];
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        if (count($requestedData->CHECKLIST)) {
            foreach ($requestedData->CHECKLIST as $vvsInspectionChGen) {
                $vvsInspectionChkListData[] = [
                    'INSPECTION_ID'      => $inspectionId,
                    'CHECKLIST_ID'      => $vvsInspectionChGen->CHECKLIST_ID,
                    'OPTION_ID'      => $vvsInspectionChGen->OPTION_ID,
                    'CHECKLIST_NAME'    => $vvsInspectionChGen->CHECKLIST_NAME,
                    'OPTION_NAME'   => $vvsInspectionChGen->OPTION_NAME,
                    'REMARKS' =>  $vvsInspectionChGen->REMARKS??"",
                    'CREATED_BY'  => $creator
                ];
            }
        }
        return $vvsInspectionChkListData;
    }

    public function inspRecipentData($inspectionId, $creator)
    {
        $vvsInspRecipentData = [];
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        if (count($requestedData->USER_ID)) {
            foreach ($requestedData->USER_ID as $vvsInspectionRecipent) {
                $vvsInspRecipentData[] = [
                    'INSP_ID'      => $inspectionId,
                    'USER_ID'   => $vsInspectionRecipent->WORKER_ID,
                    'CREATED_BY'  => $creator
                ];
            }
        }
        return $vvsInspRecipentData;
    }
}
