<?php

namespace App\Http\Requests\HIRA;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\Hira;
use App\Models\HiraActivity;
use App\Models\HiraMstDeclaration;
use App\Services\HIRA\HiraServices;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class AddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {

        $fields = ["SITE_ID", "LOCATION_ID", "TITLE", "HIRA_START_DATE", "HIRA_END_DATE"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID", "LOCATION_ID"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    private function validateDateTimeFormat($datetime)
    {
        return strtotime($datetime) !== false;
    }   

    protected function validateHiraStartDateAndEndDate($requestedData)
    {
        $error = "";
        if (
            !$this->validateDateTimeFormat($requestedData->HIRA_START_DATE)  ||
            !$this->validateDateTimeFormat($requestedData->HIRA_END_DATE)
        ) {
            $error = "Hira Start Date / Hira End Date must be a valid date.";
        }
        if ($requestedData->HIRA_START_DATE >= $requestedData->HIRA_END_DATE) {
            $error = "Hira End Date must be bigger than Hira Start Date.";
        }
        // Validate time difference (12 hours)
        //$startTime = new DateTime($requestedData->HIRA_START_DATE);
        //$endTime = new DateTime($requestedData->HIRA_END_DATE);

        //$timeDifference = $endTime->diff($startTime);

        // Check if the time difference is less than 12 hours
        //if ($timeDifference->h > 12) {
            //$error = "The time difference between Hira Start Date and Hira End Date must be less than 12 hours.";
        //}
        return $error;
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'TITLE' => 250
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
            }
        }
        return $error;
    }

    public function hiraAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE","RENEW","INITIAL","REVISE"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);

        if ($error) {
            return $error;
        }

        //hira start date and end date validation
        $error = $this->validateHiraStartDateAndEndDate($requestedData);
        if ($error) {
            return $error;
        }

        if (!in_array($action, ["DRAFT", "SAVE","INITIAL"])) {
             //declaration validation       
            if (isset($requestedData->DECLARATION)  && count( $requestedData->DECLARATION )) {
                $error = $this->validateDeclarationPopUp($requestedData->DECLARATION, 1);
            }
            if ($error) {
                return $error;
            }
        }
        
        
        return $error;
    }

    public function hiraInfoAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE","RENEW","REVISE"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        $error="";
        if (in_array($action, ["DRAFT", "SAVE","MOVE_FORWARD","SEND_BACK"])) {
            
            if(in_array($action, ["DRAFT", "SAVE"])){
                $error = $this->validateActivity($requestedData);
            }
            if(in_array($action, ["MOVE_FORWARD","SEND_BACK"])){
                if (isset($requestedData->ACTIVITY_DTLS) 
                    && is_array($requestedData->ACTIVITY_DTLS) 
                    && count($requestedData->ACTIVITY_DTLS) > 0) {
                    $error = $this->validateActivity($requestedData);
                }
            }
            
            if ($error) {
                return $error;
            }            
            //declaration validation   
            if(in_array($action, ["DRAFT", "SAVE"])){
                if (isset($requestedData->DECLARATION)  && count( $requestedData->DECLARATION )) {
                    $error = $this->validateDeclaration($requestedData->DECLARATION, 1);
                }
            }
            if(in_array($action, ["MOVE_FORWARD","SEND_BACK"])){
                if (isset($requestedData->DECLARATION)  && count( $requestedData->DECLARATION )) {
                    $error = $this->validateDeclaration($requestedData->DECLARATION, 3);
                }
            }     
            
            if ($error) {
                return $error;
            }
        }
        return $error;
    }

    protected function validateActivity($requestedData)
    {
        $error = ""; 
        if ((!isset($requestedData->ACTIVITY_DTLS) || count( @$requestedData->ACTIVITY_DTLS ) == 0) && $requestedData->ACTION == 'SAVE') {
            $error = "Activity Details is required.";
        } elseif (isset($requestedData->ACTIVITY_DTLS) && !is_array($requestedData->ACTIVITY_DTLS)) {
            $error = "Activity Details is not valid.";
        } else if(count($requestedData->ACTIVITY_DTLS) > 0) {               
            foreach ($requestedData->ACTIVITY_DTLS as $key => $value) {                
                $jobId = $value->JOB_ID;
                $activityId = $value->ACTIVITY_ID;
                $riskId = $value->RISK_RELATED_ID;
                $description = $value->DESCRIPTION;
                $ptwRequired = $value->IS_PTW_REQUIRED;
                $ptwType = $value->PTW_TYPE_ID??"";
                $severityId = $value->SEVERITY_ID;
                $likelihoodId = $value->LIKELIHOOD_ID;
                $actionOwnerId = $value->ACTION_OWNER_ID;
                $controlPlace = $value->CONTROL_IN_PLACE;
                $refDoc = $value->REF_DOC;
                $activityData = [$jobId, $riskId, $description, $ptwRequired, $severityId, $likelihoodId, $actionOwnerId];
                $activityData  = array_filter($activityData);  
                $activityFieldCount = 7;
                if (count($activityData) < $activityFieldCount) {                    
                    $error.= "Please fill all fields</br>";
                }
                foreach ($value as $key=>$numericAlias) {                    
                    if(!in_array($key, ['DESCRIPTION','CONTROL_IN_PLACE','REF_DOC','ADDTNL_CONTROL_MEASURE','ACTIVITY_ID'])){
                        if (isset($value->$key) && !is_numeric($value->$key)) {
                            $error.= "input field $key is expecting a numeric value</br>";
                        }
                    }                    
                }
                if (!isset($activityId) || !is_array($activityId) || count($activityId) <= 0) {
                    $error.= "Please select at least one activity</br>";
                }
                $stringValue = 600;
                if (isset($value->DESCRIPTION) &&
                 (!is_string($value->DESCRIPTION) || strlen($value->DESCRIPTION) > $stringValue)) {
                    $error.= "Description is expecting a string value with a maximum size of $stringValue </br>";
                }
                $stringValueAd = 250;
                if (isset($value->ADDTNL_CONTROL_MEASURE) &&
                 (!is_string($value->ADDTNL_CONTROL_MEASURE) || strlen($value->ADDTNL_CONTROL_MEASURE) > $stringValueAd)) {
                    $error.= "Description is expecting a string value with a maximum size of ".$stringValueAd." </br>";
                }
                if(!isset($value->CONTROL_IN_PLACE) || !is_array($value->CONTROL_IN_PLACE) || count($value->CONTROL_IN_PLACE) == 0){
                    $error.= "Please select Control In Place </br>";
                }
                if(count($value->CONTROL_IN_PLACE) > 0){
                    $stringValueCP = 250;                    
                    foreach ($value->CONTROL_IN_PLACE as $cvalue) {                                             
                        if ((isset($cvalue->CONTROL_IN_PLACE_NAME) && (!is_string($cvalue->CONTROL_IN_PLACE_NAME)) 
                        || (strlen($cvalue->CONTROL_IN_PLACE_NAME) > $stringValueCP))) {
                            $error.= "Control in Place is expecting a string value with a maximum size of ".$stringValueCP." </br>";
                        }
                    }
                }
                if(!isset($value->REF_DOC) || !is_array($value->REF_DOC) || count($value->REF_DOC) == 0){
                    $error.= "Please add Reference document";
                }
                if(count($value->REF_DOC) > 0){
                    $stringValueRD = 50;                    
                    foreach ($value->REF_DOC as $rvalue) {                                             
                        if ((isset($rvalue->REF_DOC_NAME) && (!is_string($rvalue->REF_DOC_NAME)) 
                        || (strlen($rvalue->REF_DOC_NAME) > $stringValueRD))) {
                            $error.= "Reference Document name is expecting a string value with a maximum size of ".$stringValueRD." </br>";
                        }
                    }
                }                    
            }
        }        
        return $error;
    }
    public function getDeclarationSectionbyAction($action){
        $declarationSection = 0;
        if ($action == "DRAFT" || $action == "SAVE"){
            $declarationSection = 1;
        }
        elseif ($action == "MOVE_FORWARD"){
            $declarationSection = 2;
        }
        elseif ($action == "APPROVE"){
            $declarationSection = 3;
        }
        elseif ($action == "REJECT"){
            $declarationSection = 4;
        }
        elseif ($action == "RENEW"){
            $declarationSection = 9;
        }
        elseif ($action == "ACM"){
            $declarationSection = 10;
        }
        elseif ($action == "REVISE"){
            $declarationSection = 9;
        }               
        return $declarationSection;
    }
    protected function validateDeclaration($declarationIds, $hiraAddPage)
    {
        $error = "";

        if (isset($declarationIds) && is_array($declarationIds)) {
            if (isset($hiraAddPage) && $hiraAddPage == 1) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
                    
            } elseif (isset($hiraAddPage) && $hiraAddPage == 2) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_MOVE_FORWARD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($hiraAddPage) && $hiraAddPage == 3) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_APPROVE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($hiraAddPage) && $hiraAddPage == 4) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_REJECT")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($hiraAddPage) && $hiraAddPage == 5) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_REQUEST_FOR_CLOSURE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($hiraAddPage) && $hiraAddPage == 6) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_CLOSE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($hiraAddPage) && $hiraAddPage == 7) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($hiraAddPage) && $hiraAddPage == 8) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_REQUEST_FOR_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            elseif (isset($hiraAddPage) && $hiraAddPage == 9) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_RENEW")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            elseif (isset($hiraAddPage) && $hiraAddPage == 10) {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_ACCEPT_CONTROL_MEASURES")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            else {
                $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->whereNot("DECLARATION_GROUP", "HIRA_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereNotIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            $data = $allDeclarationData;
            if (count($data) != count($declarationIds)) {
                $error = "Some of the Declarations are not valid </br>";
            }
        } else {
            $error = "Please check all the Declarations.</br>";
        }
        return $error;
    }

    protected function validateDeclarationPopUp($declarationIds, $hiraAddPage)
    {
        $error = "";
        if (isset($declarationIds) && is_array($declarationIds)) {
            $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "HIRA_ADD_POP_ONE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            $data = $allDeclarationData;
            if (count($data) != count($declarationIds)) {
                $error = "Some of the Declarations are not valid";
            }
        } else {
            $error = "Please check all the Declarations.";
        }
        return $error;
    }


    public function hiraSaveValidation()
    {
        $error = "";
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);

        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "";

        if (!in_array($action, ["MOVE_FORWARD","SEND_BACK","APPROVE","REJECT"])) {
            $error = "Please mention the type of activity in terms of ACTION.";
        }

        if (empty($requestedData->ID)) {
            $error = "Hira Id should not be blank.";
        }
        if (!is_numeric($requestedData->ID)) {
            $error = "Hira Id should is not a valid number.";
        }

        if ($error) {
            return $error;
        }

        $declarationSection = $this->getDeclarationSectionbyAction($action);
        
        //declaration validation
        if (isset($requestedData->DECLARATION)) {
            $error = $this->validateDeclaration($requestedData->DECLARATION, $declarationSection);
        }

        if($requestedData -> ACTION == "CLOSE"){
            $error = $this -> validateCaptcha($requestedData);
            
        } 

        return $error;
    }

    public function hiraAddACMValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE","RENEW","ACM","REVISE"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        
        $hira = Hira::where("ID",$requestedData->ID)->first();
        $hiraActivity = HiraActivity::where("ID",$requestedData->ACTIVITY_ID)->first();
        if($hira->STAGE_ID != 5 && $hiraActivity->STAGE_ID != 2){
            return "You are not permitted to this work";
        }
        
        $declarationSection = $this->getDeclarationSectionbyAction($action);
         //declaration validation       
         if (isset($requestedData->DECLARATION)  && count( $requestedData->DECLARATION )) {
            $error = $this->validateDeclaration($requestedData->DECLARATION, $declarationSection);
        }
        if ($error) {
            return $error;
        }
        
        return $error;
    }
    
}
