<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Http;

class SystemUpDownMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
            $response = Http::post(env("PTW_URL")."/running-system", ["module_name" => env("PTW_MODULE_NAME")]);
            $vvsPtwIsRunning = $response->json();
            
            if ($vvsPtwIsRunning === 0) {
                return response()->json([
                    'success' => 0,
                    'message' => env("PTW_MODULE_NAME").' Module is down, please try again later.'
                ]);
            }
        } catch (\Throwable $e) {
            // Handle the error gracefully
            return response()->json([
                'success' => 0,
                'message' => 'An error occurred while checking the status of '.env("PTW_MODULE_NAME").' Module.'
            ]);
        }
        
        return $next($request);
    }

}
