<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\TRAINING\TrainingInterface;
use App\Http\Traits\InvalidTokenCheck;
use App\Http\Requests\TRAINING\AddRequest;
use Illuminate\Support\Facades\File;

class TrainingControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(TrainingInterface $repository){
        $this->repository = $repository;
    }
    /**
     * Store a newly created resource in storage.
     */
    public function trainingAdd(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function trainingDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingDetails($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function trainingList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingList($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function trainingListCal(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingListCal($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function trainingListOnDemand(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingListOnDemand($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function trainingAddCal(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingAddCal($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function trainingDetailsExport(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->trainingDetailsExport($request);
    }
}
