<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PtwMstType;
use App\Repositories\Report\ReportPtwInterface;
use App\Http\Traits\InvalidTokenCheck;
use Illuminate\Support\Facades\File;





class ReportPtwControllerV1 extends Controller
{
    use InvalidTokenCheck;
    private $repository;

    public function __construct(ReportPtwInterface $repository){
        $this->repository = $repository;
    }
    
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return response()->json(PtwMstType::all());   
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwListReport(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listPtwReport($request);
    }
}