<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InspectionMstType;
use App\Repositories\Report\ReportInspectionInterface;
use App\Http\Traits\InvalidTokenCheck;
use Illuminate\Support\Facades\File;

class ReportInspectionControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(ReportInspectionInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function inspectionListReport(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listInspectionReport($request);
    }
}