<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Repositories\Report\ReportHiraInterface;
use App\Http\Traits\InvalidTokenCheck;

class ReportHiraControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(ReportHiraInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //code
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraListReport(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listHiraReport($request);
    }
}