<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\OBSERVATION\ObservationMasterListInterface;
use App\Http\Traits\InvalidTokenCheck;

class ObservationMasterListControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;
     
    public function __construct(ObservationMasterListInterface $repository){
        $this->repository = $repository;
    }

      /**
     * Store a newly created resource in storage.
     */
    public function masterListObservation(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->masterListObservation($request);
    }
}
