<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\OBSERVATION\ObservationInterface;
use App\Http\Requests\OBSERVATION\AddRequest;
use App\Http\Traits\InvalidTokenCheck;

class ObservationControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(ObservationInterface $repository){
        $this->repository = $repository;
    }
    /**
     * Store a newly created resource in storage.
     */
    public function observationList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listObservation($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function observationDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->observationDetails($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function observationAdd(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->observationAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function observationDetailsExport(Request $request)
    {        
        return $this->repository->observationDetailsExport($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function observationDownloadableList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->observationDownloadableList($request);
    }

    public function commentLog(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->commentLog($request);
    }

    public function actionTakenLog(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->actionTakenLog($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function obsAddDeclarationM(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->obsAddDeclarationM($request);
    }
}
